/*
 * UndoStretchSelection.java
 *
 * Created on February 1, 2010, 2:10 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import org.biolegato.gdesupport.canvas.textarea.BLTextArea;
import org.biolegato.gdesupport.canvas.textarea.GDETextArea;
import org.biolegato.gdesupport.canvas.textarea.UndoableGDETextArea;

/**
 * This object handles undoing selection stretches within a GDETextArea.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoStretchSelection implements Undoable {
    /**
     * The original X-coordinate of end of the selection
     */
    private int x;
    /**
     * The original Y-coordinate of end of the selection
     */
    private int y;
    /**
     * The source of the selection stretch
     */
    private UndoableGDETextArea source;

    /** Creates a new instance of UndoChangePosition */
    public UndoStretchSelection(final UndoableGDETextArea source, final int x, final int y) {
	this.x = x;
	this.y = y;
	this.source = source;
    }

    /**
     * Undoes the stretching of a selection
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	return source.ustretchSelection(x, y);
    }

}
