package org.biolegato.ezmenu.variables;


import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import org.biolegato.core.main.BLMain;
/*
 * BLComboBox.java
 *
 * Created on June 16, 2008, 1:40 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

/**
 * A wrapper class used to abstract choice lists within command windows.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEChoiceList extends GDEWidgetVariable {
    /**
     * The list of choices
     */
    protected HashMap<Object, Object> choices = null;
    /**
     * The combobox contianing the data.
     */
    protected JList choice_list = null;
    /**
 * Used for serialization purposes.
 */
    private static final long serialVersionUID = 7526472295622776158L;

    /**
     * Creates a new instance of GDEComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with.
     */
    public GDEChoiceList (java.util.Map data) {
	super(data);

	int defaultEntry = 0;
	String[] orderChoices = null;         // used for default values

	// a combo box which returns its value when toString is called
	if (data.containsKey("description")) {
	    this.add(new JLabel(data.get("description").toString()));
	}

	if (data.containsKey("choices") && data.get("choices") instanceof java.util.Map) {
	    choices = new HashMap<Object, Object>((java.util.Map<? extends Object, ? extends Object>) data.get("choices"));
	    if (data.containsKey("choiceorder") && data.get("choiceorder") instanceof String[]) {
		orderChoices = (String[]) data.get("choiceorder");
		choice_list = new JList(orderChoices);
	    } else {
		choice_list = new JList(choices.keySet().toArray());
	    }

            // handle the default value for the list
	    if (data.containsKey("default")) {
		for (Map.Entry<Object, Object> e : choices.entrySet()) {
		    if (e.getValue().toString().equalsIgnoreCase(data.get("default").toString())) {
			choice_list.setSelectedValue(e.getKey(), true);
		    }
		}
	    }
            // make the choice_list only support single selection
            choice_list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

            // add the choice list (and make it scrollable)
	    this.add(new JScrollPane(choice_list, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED));
	} else {
		BLMain.error("Invalid argument (missing choice list)", "BLComboBox");
	}
    }

    /**
     * Returns the name of this type of variable.
     * 
     * @return the name of the variable type "choice_list".
     */
    public static String getType () {
	    return "choice_list";
    }

    /**
     * Returns the value of the variable.
     *
     * @return the current value of the widget.
     */
    public Object getValue () {
	    return choices.get(choice_list.getSelectedValue());
    }
}
