/*
 * UndoInsert.java
 *
 * Created on January 19, 2010, 1:39 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.gdesupport.canvas.textarea.GDETextArea;
import org.biolegato.gdesupport.canvas.textarea.UndoableGDETextArea;

/**
 * This object handles undoing text insertion within a UndoableGDETextArea
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoInsert implements Undoable {
    
    /**
     * The X-coordinate of the insertion
     */
    private int x;
    /**
     * The Y-coordinate of the insertion
     */
    private int y;
    /**
     * The length along the X-axis of the insertion
     */
    private int w;
    /**
     * The length along the Y-axis of the insertion
     */
    private int h;
    /**
     * The source of the insertion
     */
    private UndoableGDETextArea source;
    
    /** Creates a new instance of UndoInsert */
    public UndoInsert(final UndoableGDETextArea source, final int x, final int y, final int w) {
	this(source, x, y, w, 0);
    }
    /** Creates a new instance of UndoInsert */
    public UndoInsert(final UndoableGDETextArea source, final int x, final int y, final int w, final int h) {
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
	this.source = source;
    }

    /**
     * Undoes a text insertion
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	return source.udelete(x, y, w, h);
    }
    
}
