/*
 * UndoRowInsertion.java
 *
 * Created on February 16, 2010, 2:09 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.sequence.Sequence;

/**
 * This object handles undoing sequence row inesrtions
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoRowInsertion implements Undoable {
    
    /**
     * The lineNumber of the insertion
     */
    private int lineNumber;
    /**
     * The source of the insertion
     */
    private SeqDoc source;
    
    /**
     * Creates a new instance of UndoRowInsertion
     */
    public UndoRowInsertion(SeqDoc source, int lineNumber) {
	this.source = source;
	this.lineNumber = lineNumber;
    }
    
    /**
     * Undoes a row insertion
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	Undoable result = new UndoRowDeletion(source, lineNumber, source.getLine(lineNumber));
	source.removeSequence(lineNumber);
	return result;
    }
}
