/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biolegato.ezmenu;

import java.awt.Container;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Map;
import org.biolegato.ezmenu.variables.GDETempFile;
import org.biolegato.ezmenu.variables.GDEVariable;
import org.biolegato.ezmenu.variables.GDEWidgetVariable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.biolegato.core.main.BLMain;

/**
 * The window used for setting options to run a menu command.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class EZMenuItem implements ActionListener {

    /**
     * Determines whether the program has widgets that require input.
     * If there are no widgets the program will launch automatically when called.
     */
    private boolean isDisplayWindow = false;
    /**
     * The name of the command to run
     */
    private String name;
    /**
     * This variable stores the basic command string.
     * This basic command string will be used to determine the command to run,
     * and will be left unmodified after execution.
     */
    private String command = "";
    /**
     * List of buttons for the window
     */
    private LinkedList<Action> buttonList = new LinkedList<Action>();
    /**
     * The list of variabes currently used by the window.  This is used for
     * creating the runtime command string.
     */
    protected LinkedList<Map<String, Object>> variables = new LinkedList<Map<String, Object>>();
    /**
     * Used in serialization.
     */
    private static final long serialVersionUID = 7526472295622777007L;

    /**
     * Creates a new instance of a run window.
     *
     * @param name the name of the run window.
     */
    public EZMenuItem(String name) {
        // set the appropriate class variables
        this.name = name;
    }

    /**
     * Adds a button to the window.
     *
     * @param run the AbstractAction used to create the button
     */
    public void addButton(Action run) {
        buttonList.add(run);
    }

    /**
     * This function is used to add variables to the window.
     *
     * @param variable the variable to add to the window
     */
    public void addVariable(Map<String, Object> variable) {
        variables.add(variable);
    }

    /**
     * Changes the command string.
     *
     * @param command the command string to change to.
     */
    public void setCommand(String command) {
        this.command = command;
    }

    /**
     * Makes the window visible so all of the variables may be set.
     *
     * @param event this is currently ignored
     */
    public void actionPerformed(ActionEvent event) {
        new EZRunWindow(name, command, buttonList.toArray(new Action[0]), variables);
    }
}
