/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

/**
 * An interface to group together all objects which support cut/copy/paste.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface Editable {
    /**
     * Cuts content from the current Editable object to the clipboads.
     */
    public void cut();

    /**
     * Copies content from the current Editable object to the clipboads.
     */
    public void copy();

    /**
     * Pastes the current clipboard into the current Editable object.
     */
    public void paste();
}
