/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.colourmap;

import java.util.Hashtable;
import org.biolegato.gdesupport.canvas.colourmask.GDEColourMaskFile;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;
import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;

/**
 * A colour map class that will give support for GDE style colour schemes
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class CharacterColourMap extends MonochromeColourMap {

    /**
     * The hashtable of colours to use.
     */
    private Hashtable<Character,Color> hash;
    
////////////////////////////////////
//********************************//
//* STANDARD CONTRASTING COLOURS *//
//********************************//
////////////////////////////////////
    /**
     * Standard neutral colour
     */
    public static final Color neutralColour = new Color(64, 64, 64);    // MediumGrey
    
    /**
     * Creates a new instance of GDECharColourMap
     */
    public CharacterColourMap(String name, Hashtable<Character,Color> hash) {
	setName(name);
	this.hash = hash;
    }

    /**
     * Draws a sequence mapping the appropriate colours to each character rendered
     *
     * @param ta the textarea to use for obtaining metrics from.
     * @param gfx the graphics object to draw the string to.
     * @param xstart the x co-ordinate to start drawing from.
     * @param ystart the y co-ordinate to start drawing from.
     * @param seq the sequence to draw.
     */
    @Override
    public void regularDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq, int pstart, int pend) {
        char[] stringArray = safesubstring(seq, pstart, pend).toCharArray();
        Color fgCurrent = foreground;

	for (int count = 0; count < stringArray.length; count++) {
	    if (hash.containsKey(Character.toLowerCase(stringArray[count]))) {
		fgCurrent = hash.get(Character.toLowerCase(stringArray[count]));
	    } else {
		fgCurrent = foreground;
	    }
	    
	    drawChars(ta, gfx, xstart, ystart, stringArray, count, 1, fgCurrent, background);
	    xstart += ta.columnSize();
	}
    }
}
