/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.colourmap;

import org.biolegato.gdesupport.canvas.colourmask.GDEColourMaskFile;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;
import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;

/**
 * A colour map class that will give support for GDE style colour schemes
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDECharColourMap extends MonochromeColourMap {

////////////////////////////////////
//********************************//
//* STANDARD CONTRASTING COLOURS *//
//********************************//
////////////////////////////////////
    /**
     * Standard neutral colour
     */
    public static final Color neutralColour = new Color(64, 64, 64);    // MediumGrey
    
    /**
     * Creates a new instance of GDECharColourMap
     */
    public GDECharColourMap() {
	setName("<default>");
    }

    /**
     * Creates a new instance of GDECharColourMap
     *
     * @param foreground the colour to use as the regular foreground for unselected text.
     * @param background the colour to use as the background for unselected text.
     * @param foregroundSelect the colour to use as the foreground for selected text.
     * @param backgroundSelect the colour to use as the background for selected text.
     */
    public GDECharColourMap (Color foreground, Color background, Color foregroundSelect, Color backgroundSelect) {
        super(foreground, background, foregroundSelect, backgroundSelect);
	setName("<default>");
    }
    
    /**
     * Draws a sequence mapping the appropriate colours to each character rendered
     *
     * @param ta the textarea to use for obtaining metrics from.
     * @param gfx the graphics object to draw the string to.
     * @param xstart the x co-ordinate to start drawing from.
     * @param ystart the y co-ordinate to start drawing from.
     * @param seq the sequence to draw.
     */
    @Override
    public void regularDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq, int pstart, int pend) {
        char[] stringArray = safesubstring(seq, pstart, pend).toCharArray();
        Color fgCurrent = foreground;

        if (seq.get("mask") instanceof ColourMap) {
            ((ColourMap)seq.get("mask")).regularDrawString(ta, gfx, xstart, ystart, seq, pstart, pend);
        } else {
            for (int count = 0; count < stringArray.length; count++) {
                if (Sequence.Type.DNA.equals(seq.get("type")) || Sequence.Type.RNA.equals(seq.get("type"))) {
                    switch (stringArray[count]) {
                        case 'A': case 'a':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(1);
                            break;
                        case 'B': case 'D': case 'H': case 'I': case 'K': case 'N': case 'M': case 'R': case 'S': case 'V': case 'W': case 'Y':
                        case 'b': case 'd': case 'h': case 'i': case 'k': case 'n': case 'm': case 'r': case 's': case 'v': case 'w': case 'y':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(2);
                            break;
                        case 'C': case 'c':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(3);
                            break;
                        case 'G': case 'g':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(4);
                            break;
                        case 'T': case 't': case 'U': case 'u':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(5);
                            break;
                        case 'X':
                            stringArray[count] = 'N';
                            fgCurrent = GDEColourMaskFile.getDefaultColour(2);
                            break;
                        case 'x':
                            stringArray[count] = 'n';
                            fgCurrent = GDEColourMaskFile.getDefaultColour(2);
                            break;
                        default:
                            stringArray[count] = '-';
                            fgCurrent = neutralColour;
                            break;
                    }
                } else if (Sequence.Type.PROTEIN.equals(seq.get("type"))) {
                    switch (stringArray[count]) {
                        case 'A': case 'G': case 'O': case 'P': case 'S': case 'T':
                        case 'a': case 'g': case 'o': case 'p': case 's': case 't':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(6);
                            break;
                        case 'B': case 'D': case 'E': case 'N': case 'Q': case 'Z':
                        case 'b': case 'd': case 'e': case 'n': case 'q': case 'z':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(4);
                            break;
                        case 'C': case 'c':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(1);
                            break;
                        case 'F': case 'W': case 'Y':
                        case 'f': case 'w': case 'y':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(3);
                            break;
                        case 'H': case 'K': case 'R':
                        case 'h': case 'k': case 'r':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(7);
                            break;
			case 'I': case 'J': case 'L': case 'M': case 'V':
                        case 'i': case 'j': case 'l': case 'm': case 'v':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(5);
                            break;
                        case 'X': case '*': case 'x':
                            fgCurrent = GDEColourMaskFile.getDefaultColour(2);
                            break;
                        default:
                            fgCurrent = neutralColour;
                            break;
                    }
                } else {
                    fgCurrent = foreground;
                }
                drawChars(ta, gfx, xstart, ystart, stringArray, count, 1, fgCurrent, background);
                xstart += ta.columnSize();
            }
        }
    }
}
