/*
 * UndoMoveSelection.java
 *
 * Created on February 1, 2010, 2:09 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import org.biolegato.gdesupport.canvas.textarea.BLTextArea;
import org.biolegato.gdesupport.canvas.textarea.GDETextArea;
import org.biolegato.gdesupport.canvas.textarea.UndoableGDETextArea;

/**
 * This object handles undoing selection movement within a UndoableGDETextArea.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoMoveSelection implements Undoable {
    /**
     * The original X-coordinate of start of the selection
     */
    private int x;
    /**
     * The original Y-coordinate of start of the selection
     */
    private int y;
    /**
     * The source of the move selection
     */
    private UndoableGDETextArea source;

    /** Creates a new instance of UndoMoveSelection */
    public UndoMoveSelection(final UndoableGDETextArea source, final int x, final int y) {
	this.x = x;
	this.y = y;
	this.source = source;
    }

    /**
     * Undoes the movement of a selection area
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	return source.umoveSelection(x, y);
    }

}
