/*
 * UndoRowDeletion.java
 *
 * Created on February 16, 2010, 2:09 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.sequence.Sequence;

/**
 * This object handles undoing sequence row deletions
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoRowDeletion implements Undoable {
    
    /**
     * The lineNumber of the deletion
     */
    private int lineNumber;
    /**
     * The deleted sequence
     */
    private Sequence deleted;
    /**
     * The source of the deletion
     */
    private SeqDoc source;
    
    /**
     * Creates a new instance of UndoRowDeletion
     */
    public UndoRowDeletion(SeqDoc source, int lineNumber, Sequence deleted) {
	this.source = source;
	this.lineNumber = lineNumber;
	this.deleted = deleted;
    }
    
    /**
     * Undoes a row deletion
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	source.addSequence(lineNumber, deleted);
	return new UndoRowInsertion(source, lineNumber);
    }
}
