package org.biolegato.ezmenu.variables;

/*
 * BLRadioButtons.java
 *
 * Created on November 19, 2007, 2:45 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/**
 * Wrapper class for a group of radiobuttons.
 * NOTE: This can be added to any JContainer since it extends JPanel.
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEChooser extends GDEWidgetVariable implements ActionListener {
	/**
     * Stores the current value selected by the chooser.
     */
	private String value = "";
	/**
     * Required for serialization purposes.
     */
	private static final long serialVersionUID = 7526472295622776152L;

	/**
	 * Creates a new instance of GDEChooser.
     *
	 * @param data The value/name list of each of the radiobuttons
	 */
	public GDEChooser (java.util.Map<String, Object> data) {
		super(data);

		String[] entries = null;
		ButtonGroup group = new ButtonGroup();
		JPanel panel = new JPanel();
		JRadioButton radio;
		HashMap<Object, Object> choices = null;      // the list of choices

		if (data.containsKey("description")) {
			this.add(new JLabel(data.get("description").toString()));
		}

		if (data.containsKey("choices") && data.get("choices") instanceof java.util.Map) {
			// add the radio buttons to the list
			choices = new HashMap<Object, Object>((java.util.Map<? extends Object, ? extends Object>) data.get("choices"));
			if (data.containsKey("choiceorder") && data.get("choiceorder") instanceof String[]) {
				entries = (String[]) data.get("choiceorder");
			} else {
				entries = choices.keySet().toArray(new String[0]);
			}
			if (data.containsKey("default")) {
			    value = data.get("default").toString();
			}
			for (Object entry : entries) {
				radio = new JRadioButton(entry.toString());
				panel.add(radio);
				radio.setActionCommand(choices.get(entry).toString());
				radio.addActionListener(this);
				if (choices.get(entry).toString().equalsIgnoreCase(value)) {
					radio.setSelected(true);
				}
				group.add(radio);
			}
		}
		this.add(panel);
	}

	/**
	 * Handles selection changes of the radio buttons.
     *
	 * @param e used to determine which button is selected (by use of getActionCommand()).
	 */
	public void actionPerformed (ActionEvent e) {
		value = e.getActionCommand();
	}

	/**
	 * Returns the name of this type of variable.
     *
	 * @return "chooser" - the name of the variable type.
	 */
	public static String getType () {
		return "chooser";
	}

	/**
	 * Returns the value of the variable.
	 *
	 * @return the current value of the variable
	 */
	public Object getValue () {
		return value;
	}
}
