package org.biolegato.ezmenu.variables;

/*
 * BLTextField.java
 *
 * Created on June 16, 2008, 2:08 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.biolegato.core.main.BLMain;

/**
 * A wrapper class used to abstract file selection within command windows.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEFileChooser extends GDETextField implements ActionListener {

    /**
     * Creates a new instance of GDETempFile.
     *
     * @param data the data to create the temporary file variable with.
     */
    public GDEFileChooser (java.util.Map data) {
        super(data);

	JButton pickFile = new JButton("Choose file...");
	
        pickFile.addActionListener(this);

        this.add(pickFile);
    }

    /**
     * Returns the type name
     * @return "tempfile"
     */
    public static String getType () {
        return "file_chooser";
    }

    /**
     * Handle the choose file button
     *
     * @param e ignored because there is only one widget calling this method.
     */
    public void actionPerformed (ActionEvent e) {
        JFileChooser openDialog = new JFileChooser();
        openDialog.setCurrentDirectory(new File(System.getProperty(
                "user.dir")));
        openDialog.setAcceptAllFileFilterUsed(true);
        
        // if a file is selected, open it
        if (openDialog.showOpenDialog(BLMain.getJFrame()) == JFileChooser.APPROVE_OPTION) {
	    textfield.setText("\"" + openDialog.getSelectedFile().getPath() + "\"");
        }
    }
}
