//=====================================================================
// File:    BinOperation.java
// Class:   BinOperation
// Package: AFLPcore
//
// Author:  James J. Benham
// Date:    August 10, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPcore;

/**
 * This is an abstract class that represents operations on a bin.
 * Operations can be performed either on a set of bins or just a single
 * bin.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 10, 1998
 */

public abstract class BinOperation extends Operation
{
  /**
   * Tells wether the this operation supports a single bin, or a multi-bin
   * operation.
   */
  public abstract boolean isMultiBin();

  /**
   * This performs some sort of operation on the bin. 
   *
   * @param bin   the bin to use
   */
  public abstract void doBinOp(Bin bin);

  /**
   * This performs some sort of operation on all of the bins
   *
   * @param bins   the bins in the gel
   */
  public abstract void doBinOp(DataList bins);
}
