//=====================================================================
// File:    CutoffMgr.java
// Class:   CutoffMgr
// Package: AFLPcore
//
// Author:  James J. Benham
// Date:    August 10, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPcore;

/**
 * This class contains a list of <code>CutoffFunction</code>s which can be used
 * to read create different functions for the cutoff. For example, a cutoff
 * could be a horizontal line, a slanted line, a exponential curve, etc. 
 * Each filter is associated with a <code>String</code>, which represents 
 * its name. The pairing features are inherited from the <code>Manager</code>
 * class.
 *
 * <p>The filters can be retrieved based on their name, and a lists of
 * names can be obtained from the CutoffMgr. The CutoffFunction will contain
 * addtional information about the type of function it represents as well
 * as the parameters needed to set it up.
 *
 * @see CutoffFunction
 * @see Manager
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 10, 1998
 */

public class CutoffMgr extends Manager
{
  /**
   * Creates a new CutoffMgr, with a default capacity of 4 and a 
   * loadFactor of 1.0. Sets up the Hashtable for the String/CutoffFunction
   * pairs.
   */
  public CutoffMgr()
  {
    super();
  }

  /**
   * Creates a new CutoffMgr with the specified values.
   *
   * @param capacity  the initial number of filters that can be stored.
   * @param loadFactor controls memory efficiency vs. lookup speed, it
   *  must be between 0.0 and 1.0, where 1.0 has the greatest memory efficiency
   *
   * @exception IllegalArgumentException when <code>capacitly</code> is less
   *    than zero or the <code>loadFactor</code> is out of bounds.
   */
  public CutoffMgr(int capacity, float loadFactor)
       throws IllegalArgumentException
  {
    super(capacity, loadFactor);
  }

  /**
   * Checks to see if the specified operation is a
   * <code>CutoffFunction</code>.
   * 
   * @return <code>true</code> if it is, <code>false</code> if 
   *      it is not.
   *
   * @see CutoffFunction
   */
  public boolean classTypeOk(Operation op)
  {
    return(op instanceof CutoffFunction);
  }

}
