//=====================================================================
// File:    MissingParameterError.java
// Class:   MissingParameterError
// Package: AFLPcore
//
// Author:  James J. Benham
// Date:    August 10, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPcore;

/**
 * Thrown to indicate that a method does not have all of the required
 * parameters to run. The most likely cause would be an operation that
 * requires certain options to be set.
 *
 * @see Operation
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 10, 1998
 */

public class MissingParameterError extends Error
{
  /**
   * Constructs a <code>MissingParameterError</code> with no detailed
   * message.
   */
  public MissingParameterError()
  {
    super();
  }

  /**
   * Constructs a <code>MissingParameterError</code> with the specified 
   * detailed message.
   *
   * @param s  the detailed error message.
   */
  public MissingParameterError(String s)
  {
    super(s);
  }
}
