//=====================================================================
// File:    ScanCalcError.java
// Class:   ScanCalcError
// Package: AFLPcore
//
// Author:  James J. Benham
// Date:    August 10, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPcore;

/**
 * Thrown to indicate that a method cannot determine the scan number from
 * a given size. For example, the sizing function f(n) may not have an
 * inverse function, which means that a method must "guess" at which value
 * is correct.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 10, 1998
 */

public class ScanCalcError extends Error
{
  /**
   * Constructs a <code>ScanCalcError</code> with no detailed
   * message.
   */
  public ScanCalcError()
  {
    super();
  }

  /**
   * Constructs a <code>ScanCalcError</code> with the specified 
   * detailed message.
   *
   * @param s  the detailed error message.
   */
  public ScanCalcError(String s)
  {
    super(s);
  }
}
