//=====================================================================
// File:    Bar.java
// Class:   Bar
// Package: AFLPgui
//
// Author:  James J. Benham
// Date:    August 11, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPgui;

import java.awt.Panel;
import java.awt.Color;
import java.awt.Graphics;

/**
 * This class will provide a panel that automatically includes lines seperating
 * it on the top and bottom. The top and bottom lines can be turned off
 * if desired.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 11, 1998
 */

public class Bar extends Panel
{
  private boolean drawTop;
  private boolean drawBottom;

  /**
   * Creates a new Bar, which will draw both the top and bottom borders.
   */
  public Bar()
  {
    super();

    drawTop = true;
    drawBottom = true;
    setBackground(Color.lightGray);
  }

  /**
   * Creates a new Bar, drawing the specified borders.
   *
   * @param drawTop specifies if the top seperating line should be drawn.
   *   <code>true</code> for the line to show up.
   * @param drawBottom specifies if the bottom line should be drawn.
   */
  public Bar(boolean drawTop, boolean drawBottom)
  {
    super();

    this.drawTop = drawTop;
    this.drawBottom = drawBottom;

    setBackground(Color.lightGray);
  }
  
  /**
   * This method is used to draw the border and then it calls the paint
   * method of the super so components get drawn properly.
   */
  public void paint(Graphics g)
  {    
    // get the size and width of the box
    int width = getSize().width;
    int height = getSize().height;
    
    if(drawTop)
      {
	g.setColor(new Color(127, 127, 127) );
	g.drawLine(0, 0, width, 0);
	g.setColor(Color.white);
	g.drawLine(0, 1, width, 1);
      }

    if(drawBottom)
      {
	g.setColor(new Color(127, 127, 127) );
	g.drawLine(0, height - 2, width, height - 2);
	g.setColor(Color.white);
	g.drawLine(0, height - 1, width, height - 1);
      }

    // Let the superclass handle drawing of any added components
    super.paint(g);
  }

  /**
   * Tells whether or not this bar has a top border.
   *
   * @return <code>true</code> if the border is drawn, <code>false</code>
   *    otherwise.
   */
  public boolean hasTopBorder()
  {
    return drawTop;
  }

  /**
   * Tells whether or not this bar has a bottom border.
   *
   * @return <code>true</code> if the border is drawn, <code>false</code>
   *    otherwise.
   */
  public boolean hasBottomBorder()
  {
    return drawBottom;
  }

  /**
   * Sets the borders for the bar. <code>true</code> indicates that the
   * border should be drawn.
   *
   * @param top      controls the top border
   * @param bottom   controls the bottom border
   */
  public void setBorders(boolean top, boolean bottom)
  {
    drawTop = top;
    drawBottom = bottom;
  }
}
