//=====================================================================
// File:    ControlBar.java
// Class:   ControlBar
// Package: AFLPgui
//
// Author:  James J. Benham
// Date:    August 11, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPgui;

import java.awt.Panel;
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * This class displays buttons on a panel. The buttons are labeled "Gel,"
 * "Thumbnail," "Graph," "Trace," and "Analysis." When one of these buttons
 * is clicked, the <code>switchTo(String)</code> method in the parent
 * (specified in the constructor) is called. The buttons are laid out in
 * a vertical manner.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 11, 1998
 */

public class ControlBar extends Panel implements ActionListener
{
  private int BUTTON_WIDTH = 75;
  private int BUTTON_HEIGHT = 22;
  private int BUTTON_VSPACE = 0;
  private int BUTTON_HSPACE = 6;
  private int BUTTON_INIT_VSPACE = 5;

  private int PANEL_WIDTH = 87;
  private int PANEL_HEIGHT = 100;

  private Button gelButton;
  private Button thumbnailButton;
  private Button graphButton;
  private Button analysisButton;
  private Button traceButton;

  private FragmentMap parent;

  /**
   * Create a new ControlBar with the specified parent. The parent is
   * responsible for handling the events generated by the buttons on this
   * control panel.
   *
   * @param parent  the object that will handle the events from the
   *                panel.
   */
  public ControlBar(FragmentMap parent)
  {
    this.parent = parent;

    setBackground(Color.lightGray);
    setLayout(null);

    gelButton = new Button("Gel");
    thumbnailButton = new Button("Thumbnail");
    graphButton = new Button("Graph");
    traceButton = new Button("Trace");
    analysisButton = new Button("Analysis");

    gelButton.addActionListener(this);
    thumbnailButton.addActionListener(this);
    graphButton.addActionListener(this);
    traceButton.addActionListener(this);
    analysisButton.addActionListener(this);

    placeButton(gelButton, 0);
    placeButton(thumbnailButton, 1);
    placeButton(graphButton, 2);
    placeButton(traceButton, 3);
    placeButton(analysisButton, 4);

    setSize(PANEL_WIDTH, PANEL_HEIGHT);
  }

  /**
   * Adds a the specified button at the given position. The position is
   * not a pixel value, it is a button value. A button at postion 1 would
   * appear right below a button at position 0, independent of the button
   * height since this method knows the button height and adjust automatically.
   *
   * @param newButton  the button to add
   * @param pos        the position of the button. 
   */
  private void placeButton(Button newButton, int pos)
  {
    add(newButton);
 
    newButton.setBounds(BUTTON_HSPACE, 
			BUTTON_INIT_VSPACE + BUTTON_VSPACE + 
			pos*(BUTTON_HEIGHT + BUTTON_VSPACE),
			BUTTON_WIDTH,
			BUTTON_HEIGHT);
  }

  /**
   * Draws a verical line down the right side.
   */
  public void paint(Graphics g)
  {
    int width = getSize().width;
    int height = getSize().height;

    g.setColor(new Color(127, 127, 127) );
    g.drawLine(width - 2, 0, width - 2, height);
    g.setColor(Color.black);
    g.drawLine(width - 1, 0, width - 1, height);
  }

  /**
   * Handles the button events by calling <code>switchTo(String)</code> in
   * the parent.
   */
  public void actionPerformed(ActionEvent e)
  {
    if(e.getSource() == gelButton)
      parent.switchTo("Gel");
    else if(e.getSource() == thumbnailButton)
      parent.switchTo("Thumbnail");
    else if(e.getSource() == graphButton)
      parent.switchTo("Graph");
    else if(e.getSource() == traceButton)
      parent.switchTo("Trace");
    else if(e.getSource() == analysisButton)
      parent.switchTo("Analysis");
  }
}
