#!/bin/csh
# This script is called by ACEDB Pick_me_to_call records.
# It chooses a viewer, depending on the file extension.
# Mime might be the 'right' way to do this, but it's
# immensly easier to just write a short script, and probably
# more reliable.

# In most cases the file extension tells us what to do with
# the file. However, we also want to be able to correctly handle
# a URL, so URL tells us if $1 is a URL, rather than a local
# file name. 
set EXT = $1:e


set URLFLAG = `echo $1 | egrep -e '^http:|^https:|^ftp:|^ftps:'`
if ($URLFLAG != "") set EXT = "html"

switch ($EXT)
  # -------- Web pages
  case "html": 
        browser.csh $1 &
    breaksw
  case "shtml": 
        browser.csh $1 &
    breaksw
  case "HTML": 
        browser.csh $1 &
    breaksw
  case "htm": 
        browser.csh $1 &
    breaksw    
  case "HTM": 
        browser.csh $1 &
    breaksw
  # -------- PDF, PostScript
  case "pdf": 
    acePDFviewer $1 &
    breaksw
  case "PDF": 
    acePDFviewer $1 &
    breaksw
  case "ps": 
    acePSviewer $1 &
    breaksw
  case "PS": 
    acePSviewer $1 &
    breaksw
  # -------- Bitmap graphics
  case "GIF": 
    aceviewer $1 &
    breaksw  
  case "gif": 
    aceviewer $1 &
    breaksw  
  case "JPG": 
    aceviewer $1 &
    breaksw  
  case "jpg": 
    aceviewer $1 &
    breaksw  
  case "JPEG": 
    aceviewer $1 &
    breaksw  
  case "jpeg": 
    aceviewer $1 &
    breaksw  
  case "PNG": 
    aceviewer $1 &
    breaksw  
  case "png": 
    aceviewer $1 &
    breaksw  
  case "BMP": 
    aceviewer $1 &
    breaksw  
  case "bmp": 
    aceviewer $1 &
    breaksw  
  case "TIF": 
    aceviewer $1 &
    breaksw  
  case "tif": 
    aceviewer $1 &
    breaksw    
  case "TIFF": 
    aceviewer $1 &
    breaksw  
  case "tiff": 
    aceviewer $1 &
    breaksw    
  # -------- Default is text editor
  default: 
    acetextedit $1 &
    breaksw
endsw

