#!/bin/sh
# For systems on which there is no PostScript viewer (an increasing
# number of systems), this script runs ps2pdf and then opens the
# PDF viewer to view the PDF file. After viewing, the 
# temporary file is deleted.  
# $ACE_Viewer is the name of the program. 
# $1 is the file for the program to use.

# RM_CMD - command to be used for removing files and directories
if [ -f /usr/bin/rm ]
then
   RM_CMD=/usr/bin/rm
else
   if [ -f /bin/rm ]
   then
      RM_CMD=/bin/rm
   else
      RM_CMD=rm
   fi
fi

#Choose a PDF viewer
if [ -z "$ACE_PDF_COMMAND" ] 
   then 
     ACE_PDF_COMMAND=gv
     export ACE_PDF_COMMAND
fi

echo Converting $1 to PDF...

tempfile=PStoPDFviewer_$$.pdf
ps2pdf $1 $tempfile

#ls -l ./$tempfile

($ACE_PDF_COMMAND $tempfile; wait; $RM_CMD -f $tempfile) &
