#!/bin/csh

# Top directory for your lab database
setenv ACEDB $BIRCH/labace
#setenv ACEDB_COMMON $ACEDB

# Directory to contain the binary database file
setenv DBDIR $ACEDB/database

# Directory for executable code specific for your database
# eg. this script
setenv BINDIR $ACEDB/bin

#Choose a WYSIWIG editor for viewing ASCII files. 
# Xcoral is a nice alternative. However, due to typical shell weirdness,
# trying to execute external programs (other than xv, for some reason)
#gives getwd errors. So, the fix is to have a shell script in a
#fully qualified path, that does what we want.
if !(${?ACE_XEditor}) setenv ACE_XEditor dtpad
setenv ACE_EDIT_COMMAND $BINDIR/acetextedit

 
#Choose a graphic viewer
if !(${?ACE_Viewer}) setenv ACE_Viewer xv
setenv ACE_VIEW_COMMAND "$BINDIR/aceviewer"


#Choose a Web browser
#if !(${?ACE_Browser}) setenv ACE_Browser /central/local/netscape7/netscape
if !(${?ACE_Browser}) setenv ACE_Browser mozilla
setenv ACE_BROWSER_COMMAND $BINDIR/aceBrowser

#Choose a .pdf viewer
if !(${?ACE_PDF_Viewer}) setenv ACE_PDF_Viewer acroread
setenv ACE_PDF_COMMAND $BINDIR/acePDFviewer

#Choose a GenBank retrieval command
if !(${?ACEFETCH}) setenv ACEFETCH $BINDIR/acefetch

# Run xace, and call cleanup.csh to make sure all files
# have correct group membership and permissions.
set path = ($BINDIR $path)


# Use this for a more diverse server cluster
# Platform-specific setup commands
setenv BIRCHLIBS  ""
switch ($BIRCH_PLATFORM)
  case "solaris-sparc":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc"
    breaksw 
  case "solaris-amd64":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-amd64:$BIRCH/local/lib-solaris-amd64"
    breaksw   
  case "sun":   # DEPRECATED
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc"
    breaksw
  case "linux-intel":
    setenv BIRCHLIBS $BIRCH/lib-linux-intel:$BIRCH/lib-linux-intel/openwin/lib:$BIRCH/local/lib-linux-intel
    breaksw
  case "linux-x86_64":
    setenv BIRCHLIBS $BIRCH/lib-linux-x86_64:$BIRCH/lib-linux-x86_64/openwin/lib:$BIRCH/local/lib-linux-x86_64
    breaksw    
  case "osx-x86_64":
    setenv BIRCHLIBS $BIRCH/lib-osx-x86_64:$BIRCH/local/lib-osx-x86_64
    breaksw 
#  case "AIX":
#    breaksw
#  case "HP":
    breaksw
  default:
    breaksw
endsw

#echo BIRCHLIBS $BIRCHLIBS
if ( "$BIRCHLIBS" != "" ) then
   if ${?LD_LIBRARY_PATH} then
      setenv LD_LIBRARY_PATH "$LD_LIBRARY_PATH":"$BIRCHLIBS"
   else
      setenv LD_LIBRARY_PATH "$BIRCHLIBS"
   endif
endif


if ( $BIRCH_PLATFORM == "osx-x86_64" ) then
   setenv DYLD_LIBRARY_PATH "$LD_LIBRARY_PATH"
   echo DYLD_LIBRARY_PATH "$DYLD_LIBRARY_PATH"
endif

#echo LD_LIBRARY_PATH $LD_LIBRARY_PATH

#(xace; $BINDIR/cleanup.csh)&
# cleanup.csh will give error messages if run by users who don't
# have write permissions for the database directroy.
# We should fix this.
(xace)&
