#!/bin/sh

# Top directory for your lab database
ACEDB=$BIRCH/labace
export ACEDB

#ACEDB_COMMON=$ACEDB; export ACEDB_COMMON

# Directory to contain the binary database file
DBDIR=$ACEDB/database
export DBDIR

# Directory for executable code specific for your database
# eg. this script
BINDIR=$ACEDB/bin
export BINDIR

echo checkpoint 1
#Choose a WYSIWIG editor for viewing ASCII files. 
# Xcoral is a nice alternative. However, due to typical shell weirdness,
# trying to execute external programs (other than xv, for some reason)
#gives getwd errors. So, the fix is to have a shell script in a
#fully qualified path, that does what we want.
if [ ! -z "${ACE_XEditor}" ] 
   then
   ACE_XEditor=gedit
fi
echo checkpoint 2
export ACE_XEditor



ACE_EDIT_COMMAND=$BINDIR/acetextedit
export ACE_EDIT_COMMAND

 
#Choose a graphic viewer
if [ ! -z "$ACE_Viewer" ]
   then
   ACE_Viewer=xv
fi
export ACE_Viewer
ACE_VIEW_COMMAND="$BINDIR/aceviewer"
export ACE_VIEW_COMMAND


#Choose a Web browser
#if !(! -z "$ACE_Browser") ACE_Browser=/central/local/netscape7/netscape
 export ACE_Browser
if [ ! -z "$ACE_Browser" ]
   then
   ACE_Browser=mozilla
fi
export ACE_Browser
ACE_BROWSER_COMMAND=$BINDIR/aceBrowser
export ACE_BROWSER_COMMAND

#Choose a .pdf viewer
if [ ! -z "$ACE_PDF_Viewer" ]
   then
   ACE_PDF_Viewer=acroread
fi
export ACE_PDF_Viewer
ACE_PDF_COMMAND=$BINDIR/acePDFviewer
export ACE_PDF_COMMAND

#Choose a GenBank retrieval command
if [ ! -z "$ACEFETCH" ] 
   then
   ACEFETCH=$BINDIR/acefetch
fi
export ACEFETCH

# Run xace, and call cleanup.csh to make sure all files
# have correct group membership and permissions.
path="$BINDIR:$PATH"


# Use this for a more diverse server cluster
# Platform-specific setup commands
BIRCHLIBS=""
export BIRCHLIBS
case $BIRCH_PLATFORM in
  "solaris-sparc")
    BIRCHLIBS="/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc"
    export BIRCHLIBS
    ;; 
  "solaris-amd64")
    BIRCHLIBS="/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-amd64:$BIRCH/local/lib-solaris-amd64"
    export BIRCHLIBS
    ;;   
  "sun")# DEPRECATED
    BIRCHLIBS="/usr/openwin/lib:/usr/lib:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc"
    export BIRCHLIBS
    ;;
  "linux-intel")
    BIRCHLIBS=$BIRCH/lib-linux-intel:$BIRCH/local/lib-linux-intel
    export BIRCHLIBS
    ;;
  "linux-x86_64")
    BIRCHLIBS=$BIRCH/lib-linux-x86_64:$BIRCH/local/lib-linux-x86_64
    export BIRCHLIBS
    ;;    
  "osx-x86_64")
    BIRCHLIBS=$BIRCH/lib-osx-x86_64:$BIRCH/local/lib-osx-x86_64
    export BIRCHLIBS
    ;; 
#  "AIX")
#    ;;
#  "HP")
#    ;;
  *)
    ;;
esac

if [ ! -z "$BIRCHLIBS" ] 
   then
   if [ ! -z "$LD_LIBRARY_PATH" ]
   	then
      LD_LIBRARY_PATH=$BIRCHLIBS:$LD_LIBRARY_PATH
   else
      LD_LIBRARY_PATH=$BIRCHLIBS
   fi
fi

export LD_LIBRARY_PATH


if [ $BIRCH_PLATFORM = "osx-x86_64" ]
   then
   DYLD_LIBRARY_PATH="$LD_LIBRARY_PATH"
   export DYLD_LIBRARY_PATH
   echo DYLD_LIBRARY_PATH "$DYLD_LIBRARY_PATH"
fi

#echo LD_LIBRARY_PATH $LD_LIBRARY_PATH
echo checkpoint 3
#(xace; $BINDIR/cleanup.csh)&
# cleanup.csh will give error messages if run by users who don't
# have write permissions for the database directroy.
# We should fix this.
(xace)&
