#!/bin/csh

# browser.failsafe.csh Version 5/16/10
# Open a browser window to a specific URL

# For BIRCH 2.7, this script is ONLY called
# from birchconfig (InstallFrame.java) to open
# a web browser when a new install is done. In the
# future, it will be converted to a .sh script
# and will replace browser.csh

# The new thing that this script does is to
# autodetect the platform, whereas the older
# browser.csh depends on BIRCH_PLATFORM being
# set.


# Synopsis: browser.csh  URL

# URL must be fully qualified. For example, for a web site
#     http://home.cc.umanitoba.ca/~frist
#
# For a file, the path does NOT need to begin with file:///
#     


# Automatic detection of the platform 
#echo 'browser.csh: Detecting platform'
#Find out the following platform parameters:
#  operating system
#  processor family

#Operating system
   set OS = `uname -s`
   switch ($OS)
      case SunOS:   
       set OS = solaris
       breaksw
     case linux:  
      set OS = linux
       breaksw
     case Darwin:  
      set OS = Darwin
       breaksw
    default
      set OS = linux  
      breaksw 
   endsw

#echo 'browser.csh: OS = '$OS
#Processor family
   set PROC = `uname -p`
   switch ($PROC)
      case sparc:
       set PROC = sparc
   	breaksw
     case i686:
      set PROC = intel
       breaksw
     case i386:
      set PROC = intel
       breaksw
     case i86pc:
      set PROC = intel
       breaksw
     case x86_64:
      set PROC = x86_64
       breaksw
    default
      set PROC = intel 
      breaksw 
   endsw

#echo 'browser.csh: PROC = ' $PROC
# Map the result to supported BIRCH platforms
   if ($OS == solaris) then
      switch ($PROC)
   	case sparc:
   	  setenv BIRCH_PLATFORM 'solaris-sparc'
   	  breaksw
   	case intel:
   	 setenv BIRCH_PLATFORM 'solaris-amd64'
   	 breaksw
       default
   	 setenv BIRCH_PLATFORM 'solaris-sparc' 
   	 breaksw 
      endsw
      else
         if ($OS == linux) then
   	 switch ($PROC)
   	   case intel:
   	    setenv BIRCH_PLATFORM 'linux-intel'
   	     breaksw
   	   case x86_64:
   	    setenv BIRCH_PLATFORM 'linux-x86_64'
   	     breaksw
   	  default
   	    setenv BIRCH_PLATFORM 'linux-intel' 
   	    breaksw 
   	 endsw

      else
         if ($OS == Darwin) then
   	 switch ($PROC)
   	   case intel:
   	    setenv BIRCH_PLATFORM 'osx-x86_64'
   	     breaksw
   	   case x86_64:
   	    setenv BIRCH_PLATFORM 'osx-x86_64'
   	     breaksw
   	  default
   	    setenv BIRCH_PLATFORM 'osx-x86_64' 
   	    breaksw 
   	 endsw

      else
         setenv BIRCH_PLATFORM 'linux-intel'  
      endif
    endif
  endif

#echo 'browser.csh: BIRCH_PLATFORM = ' "$BIRCH_PLATFORM"
# BIRCH_NETSCAPE is an environment variable telling
# the command to run your browser.
# It has been commented out below to allow it to be set
# by the user's environment
#set BIRCH_NETSCAPE = 'netscape'
#set BIRCH_NETSCAPE = 'mozilla'
#set BIRCH_NETSCAPE = 'firefox'
if ( ! ${?BIRCH_NETSCAPE} ) then
   if ( $BIRCH_PLATFORM == 'osx-x86_64' ) then
     set RESULT = 'open'
   else 
     set RESULT = `which firefox`

     if ( -z "$RESULT" ) then
       set RESULT = `which seamonkey` 
	 if ( -z "$RESULT" ) then
	 set RESULT = `which mozilla`
            if ( -z "$RESULT" ) then	 
             set RESULT = `which opera`
	    endif
	endif        
     endif 
   endif
 	  
  set BIRCH_NETSCAPE = $RESULT 
endif


# Older versions of netscape/mozilla need to be called using the
# openURL() argument, if you try to launch a new page while 
# a copy of the browser is already running. The variable BROWSER_OPENURL
# is set to 0 by default. If you are using an older browser
# such as Netscape 7.1 and earlier, BROWSER_OPENURL should be set 
# to 1.
#set BROWSER_OPENURL = 1
if ( ! ${?BROWSER_OPENURL} ) set BROWSER_OPENURL = 0


# Universal command for removing files or directories
switch (${BIRCH_PLATFORM})
  case "solaris-*" :
    set PS_CMD = 'ps -u'
    set RM_CMD = /usr/bin/rm
    breaksw
  case "sun" : # DEPRECATED
    set PS_CMD = 'ps -u'
    set RM_CMD = /usr/bin/rm
    breaksw
  case "linux-intel" :
    set PS_CMD = 'ps U'
    set RM_CMD = /bin/rm
    breaksw
  case "linux-x86_64" :
    set PS_CMD = 'ps U'
    set RM_CMD = /bin/rm
    breaksw
  case "osx-x86_64" :
    set PS_CMD = 'ps -u'
    set RM_CMD = /bin/rm
    breaksw    
  default:
    set PS_CMD = 'ps -u'
    set RM_CMD = rm
    breaksw
endsw

set USERID = `whoami`
set URL = $1


# Make sure that if URL is a local file, that
# it is a fully-qualified file path
set UCOUNT = `echo $URL | egrep -c -e 'http://'`
set FCOUNT = `echo $URL | egrep -c -e 'file:///'`
if ( "$UCOUNT"  == "0"  &&  "$FCOUNT" == "0" ) then        
   


	# Now, we have to handle cases where the path is specified
	# using an environment variable eg.
	# browser.sh $doc/Phylip/main.html
      set DNAME = `dirname $URL`
#      echo 'DNAME= '$DNAME
      set BNAME = `basename $URL`
#      echo 'BNAME =  '$BNAME

	# Special case where the file is in the current directory
	# eg. broswer.sh somethingorother.html  
	#      
	# This is the silliest piece of code I've ever written.
	# The Bourne shell is very bizzare about when and
	# where it chooses to translate "." into $PWD.
	# After trying about a million things, including escapes
	# and octal representations of ".", this appears to work
	# for the Bourne shell on both Solaris and Linux.
      set CDIR = $PWD
#      echo 'CDIR= '$CDIR
      cd $DNAME

      if ( "$CDIR" == "$PWD"  ) then
	  set DNAME = $PWD
      else
          set DNAME = "$DNAME" # force evaluation of $DNAME	 
      endif
      cd $CDIR
      set URL = file://$DNAME/$BNAME
endif

echo Opening document: $URL


if ( "$BROWSER_OPENURL" == "0" ) then

      # The most recent mozilla family of browsers automatically
      # detects whether there is already a copy of the brower
      # running, which saves a lot of headaches
      $BIRCH_NETSCAPE $URL &
else
      # For older browsers eg. Netscape 4.79 - Netscape 7.1
      #
      # Find out if there is a copy of netscape already running.
      # If there is, call netscape using -remote option, otherwise
      # launch a new netscape job.
      # See http://wp.netscape.com/newsref/std/x-remote.html
      set TEMPFILE = /tmp/browser.sh.$$
      $PS_CMD $USERID > $TEMPFILE

      set PATTERN = `basename $BIRCH_NETSCAPE` 
      set COUNT = `egrep -c -e $PATTERN < $TEMPFILE`

      if ( "$COUNT" == "0" ) then
	    $BIRCH_NETSCAPE $URL &
      else
            set REMOTESTRING = "openURL($URL,new-window)"
            $BIRCH_NETSCAPE -remote $REMOTESTRING &
      endif
      $RM_CMD $TEMPFILE
endif



