#!/bin/sh

# browser.sh Version 10/ 2/09
# Open a browser window to a specific URL


# Synopsis: browser.sh  URL

# URL must be fully qualified. For example, for a web site
#     http://home.cc.umanitoba.ca/~frist
#
# For a file, the path does NOT need to begin with file:///
#     


# BIRCH_NETSCAPE is an environment variable telling
# the command to run your browser.
# It has been commented out below to allow it to be set
# by the user's environment
#BIRCH_NETSCAPE='netscape'
#BIRCH_NETSCAPE='mozilla'
#BIRCH_NETSCAPE='firefox'
if [ -z "$BIRCH_NETSCAPE" ]
   then
      BIRCH_NETSCAPE='mozilla'
fi

# Older versions of netscape/mozilla need to be called using the
# openURL() argument, if you try to launch a new page while 
# a copy of the browser is already running. The variable BROWSER_OPENURL
# is set to 0 by default. If you are using an older browser
# such as Netscape 7.1 and earlier, BROWSER_OPENURL should be set 
# to 1.
if [ -z "$BROWSER_OPENURL" ]
   then
      BROWSER_OPENURL=0
fi



# Universal command for removing files or directories
case "$BIRCH_PLATFORM" in
  sun)
    PS_CMD='ps -u'
    RM_CMD=/usr/bin/rm
    ;;
  linux-*)
    PS_CMD='ps U'
    RM_CMD=/bin/rm
    ;;
  osx-*)
    PS_CMD='ps -u'
    RM_CMD=/bin/rm
    ;;

  *)
    PS_CMD='ps -u'
    RM_CMD=rm
    ;;
esac

USERID=`whoami`
URL=$1

#Make sure URL begins with 'http://' or 'file:///'
#UCOUNT=`echo $URL | egrep -c -e 'http://'`
#FCOUNT=`echo $URL | egrep -c -e 'file:///'`
#if [ "$UCOUNT" -eq "0"  -a  "$FCOUNT" -eq "0" ]
#   then 
#     LEADINGSLASH=`echo URL | egrep -e '^/'`    
#     if [ "$LEADINGSLASH"  -eq "" ]
#        then
#           URL='file://'$URL
#        else
#           URL='file://'$URL   
#        fi
#fi

# Make sure that if URL is a local file, that
# it is a fully-qualified file path
UCOUNT=`echo $URL | egrep -c -e 'http://'`
FCOUNT=`echo $URL | egrep -c -e 'file:///'`
if [ "$UCOUNT" -eq "0"  -a  "$FCOUNT" -eq "0" ]
   then        
   
#      if [ $DNAME -eq $PWD  ]
#         then
#	     DNAME=$PWD
#      fi

	# Now, we have to handle cases where the path is specified
	# using an environment variable eg.
	# browser.sh $doc/Phylip/main.html
      DNAME=`dirname $URL`
      echo 'DNAME= '$DNAME
      BNAME=`basename $URL`
      echo 'BNAME= '$BNAME
      export BNAME DNAME
	# Special case where the file is in the current directory
	# eg. broswer.sh somethingorother.html  
	#      
	# This is the silliest piece of code I've ever written.
	# The Bourne shell is very bizzare about when and
	# where it chooses to translate "." into $PWD.
	# After trying about a million things, including escapes
	# and octal representations of ".", this appears to work
	# for the Bourne shell on both Solaris and Linux.
      CDIR=$PWD
      echo 'CDIR= '$CDIR
      DNAME="$DNAME"
      cd $DNAME
      ls -l
      echo 'New directory: '$PWD
      if [ "$CDIR" = "$PWD"  ]
         then
	     DNAME=$PWD
         else
             DNAME="$DNAME" # force evaluation of $DNAME	 
      fi
      cd $CDIR
      URL=file://$DNAME/$BNAME
fi

echo Opening document: $URL


if [ "$BROWSER_OPENURL" -eq "0" ]
   then
      # The most recent mozilla family of browsers automatically
      # detects whether there is already a copy of the brower
      # running, which saves a lot of headaches
      $BIRCH_NETSCAPE $URL 
   else
      # For older browsers eg. Netscape 4.79 - Netscape 7.1
      #
      # Find out if there is a copy of netscape already running.
      # If there is, call netscape using -remote option, otherwise
      # launch a new netscape job.
      # See http://wp.netscape.com/newsref/std/x-remote.html
      TEMPFILE=/tmp/browser.sh.$$
      $PS_CMD $USERID > $TEMPFILE

      COUNT=`egrep -c -e "$BIRCH_NETSCAPE" < $TEMPFILE`

      if [ "$COUNT" -eq "0" ]
         then
	    $BIRCH_NETSCAPE $URL 
         else
            REMOTESTRING="openURL($URL,new-window)"
            $BIRCH_NETSCAPE -remote $REMOTESTRING 
      fi
      $RM_CMD $TEMPFILE
fi


