#!/bin/bash
# Write out the contents of a file, starting at line $1
# This command replaces 'tail +number', which is no longer
# supported in Linux

STARTINGLINE=$1
INFILE=$2
OUTFILE=$3
LINECOUNT=`wc -l $INFILE | sed -e "s/^[ ]*//" | cut -f1 -d" "`
NUMLINES=`expr $LINECOUNT` 
TAILLINES=$(($NUMLINES-$STARTINGLINE+1)) 
tail -$TAILLINES < $INFILE > $OUTFILE

