#!/bin/sh
# For all documentation in a directory, create ACEDB file
# objects in ace flatfile format

# RM_CMD - command to be used for removing files and directories
if [ -f /usr/bin/rm ]
then
   RM_CMD=/usr/bin/rm
else
   if [ -f /bin/rm ]
   then
      RM_CMD=/bin/rm
   else
      RM_CMD=rm
   fi
fi

CURRENT=$PWD
FULLPATH=$1
DIR=`echo $FULLPATH | sed -e 's%/.*/%%'`
COUNT=`echo $FULLPATH | grep -c "local"`

unset noclobber
if [ -d $FULLPATH  ]
then
   cd $FULLPATH
   for file in `ls`
      do

      if [ "$COUNT" = "0" ]
      then	 
	 FN='$dat/'$DIR'/'$file
      else
         FN='$local/dat/'$DIR'/'$file
      fi
      echo 'File : "'$FN'"' >> $CURRENT/TEMPFILE
      echo 'Pick_me_to_call "$ACE_FILE_LAUNCHER" "'$FN'"' >> $CURRENT/TEMPFILE
      echo '' >> $CURRENT/TEMPFILE
      done
   sed -e 's%/%\\/%g' < $CURRENT/TEMPFILE > $CURRENT/datfiles.ace
   $RM_CMD -f  $CURRENT/TEMPFILE
else
   echo Directory $FULLPATH not found.
fi
