#!/bin/csh

#Version 11/25/2006
# Run discrete data distance methods as a command
#Synopsis: discdist.csh infile utree ufn bstrap bseed replicates jumble jseed\
#              numjum datatype model tratio sitelen method negbranch\
#              outgroup subrep global termout printdata outfile treefile


#Convert arguments to variables
set INFILE        = $1
set UTREE         = $2
set UFN           = $3
set BSTRAP        = $4
set BSEED         = $5
set REPLICATES    = $6
set JUMBLE        = $7
set JSEED         = $8
set NUMJUM        = $9
set DATATYPE      = $10
set MODEL         = $11
set TRATIO        = $12 
set SITELEN       = $13
set METHOD        = $14
set NEGBRANCH     = $15
set OUTGROUP      = $16
set SUBREP        = $17
set GLOBAL        = $18
set TERMOUT       = $19
set PRINTDATA     = $20
set OUTFILE       = $21
set TREEFILE      = $22

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

# Do some error checking

if (-e $INFILE) then
   if (($UTREE == 'y') & (! -e $UFN)) then
      echo '!!!' USERTREE FILE $UFN DOES NOT EXIST
      exit
   endif
   if ($BSTRAP == 'n') set REPLICATES = 1

   # Create a temporary working directory
   set TEMPDIR = DISCDIST.$$
   mkdir $TEMPDIR

   # SEQBOOT requires a number in the 1st line of the input file
   # telling the number of sites. Arbitrarily set this to 1
   set FIRSTLINE = `head -1 $INFILE`
   set NUMSEQ = $FIRSTLINE[1]
    echo $FIRSTLINE 1 > $TEMPDIR/infile.temp
   # We can no longer use tail +n because the syntax is no longer consistent
   # between Unix and Linux
   #tail +2 $INFILE >> $TEMPDIR/infile.temp
   @ NUMLINES = (`wc -l $INFILE | sed -e "s/^[ ]*//" | cut -f1 -d" "`) - 1
   tail -$NUMLINES $INFILE >> $TEMPDIR/infile.temp
 

   if ($UTREE == 'y') cat $UFN >> $TEMPDIR/intree
   cd $TEMPDIR
   
   # Create bootstrapped datasets, if requested
   # Choose resampling method
   # Random seeds, odd, of the form 4n + 1
   @ tempbseed = ( ( ( $BSEED / 4 ) * 4 ) + 1 )

   switch ($BSTRAP)
     case "n":
       echo " " > MSGFILE
       cp infile.temp infile
       breaksw
     case "b":
       echo BOOTSTRAP RESAMPLING  $REPLICATES REPLICATES, SEED\=$BSEED >MSGFILE
       seqboot.csh infile.temp r $tempbseed b $REPLICATES infile
       breaksw
     case "d":
       echo DELETE-HALF JACKNIFE RESAMPLING  $REPLICATES REPLICATES, SEED\=$BSEED >MSGFILE
       seqboot.csh infile.temp r $tempbseed d $REPLICATES infile
       breaksw
     case "p":
       echo PERMUTATION RESAMPLING $REPLICATES REPLICATES, SEED\=$BSEED >MSGFILE
       seqboot.csh infile.temp r $tempbseed p $REPLICATES infile
       breaksw
   endsw
   

   # Generate distance matrices
   restdist.csh infile $REPLICATES $DATATYPE $MODEL $TRATIO $SITELEN MATRIXFILE

   # Generate a distance tree
   distance.csh MATRIXFILE $UTREE intree $REPLICATES $JUMBLE $JSEED $NUMJUM\
                $METHOD $NEGBRANCH $OUTGROUP $SUBREP $GLOBAL $TERMOUT\
                $PRINTDATA outfile treefile

   #----------- Return results to calling directory----------------
   # When using resampling or jumbling, filter the treefile through
   # consense to generate an unrooted consensus tree.
   if (($BSTRAP == 'b') || ($BSTRAP == 'p') || $BSTRAP == 'd' || $JUMBLE == 'y') then
	   cat MSGFILE outfile > ../$OUTFILE
   else
	   mv outfile ../$OUTFILE
   endif
   
   mv treefile ../$TREEFILE
   
   cd ..
   $RM_CMD -r $TEMPDIR
endif
