#!/bin/csh
# For all documentation in a directory, create ACEDB file
# objects in ace flatfile format

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

set CURRENT = $PWD
set FULLPATH = $1
set DIR = `echo $FULLPATH | sed -e 's%/.*/%%'`
set COUNT = `echo $FULLPATH | grep -c "local"`

if (-e $FULLPATH ) then
   cd $FULLPATH
   foreach file (*.pdf *.ps *.doc *.txt *.TXT *.asc *.PDF *.PS *.html *.htm *.HTML *.HTM\
        *.help *.hlp *.man *.sxw *.sxc *.sxi)
	 # Strip off leading path components, and retain the name of current directory    
	 if ( "$COUNT" == "0" ) then
            set FN = '$doc/'$DIR'/'$file
	 else
            set FN = '$local/doc/'$DIR'/'$file
	 endif
	 echo 'File : "'$FN'"' >> $CURRENT/TEMPFILE
	 echo 'Pick_me_to_call "$ACE_FILE_LAUNCHER" "'$FN'"' >> $CURRENT/TEMPFILE
	 echo '' >> $CURRENT/TEMPFILE
     end
   sed -e 's%/%\\/%g' < $CURRENT/TEMPFILE > $CURRENT/docfiles.ace
   $RM_CMD -f  $CURRENT/TEMPFILE
else
   echo Directory $FULLPATH not found.
endif
