#!/bin/csh

#Version   1/ 3/05
# Run drawgram as a command
#Synopsis: drawgram.csh treefile torient tstyle uselen langle dbratio ldratio
#                       fontfile charheight ancestnode outformat outfile

#Convert arguments to variables
set TREEFILE    = $1
set TORIENT     = $2
set TSTYLE      = $3
set USELEN      = $4
set LANGLE      = $5
set DBRATIO     = $6
set LDRATIO     = $7
set FONTFILE    = $8
set CHARHEIGHT  = $9
set ANCESTNODE  = $10
set OUTFORMAT   = $11
set OUTFILE     = $12

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

# Make a temporary directory in which to run the program
set TEMPDIR = DRAWTREE.$$
mkdir $TEMPDIR
cp $TREEFILE $TEMPDIR/intree
cd $TEMPDIR

#----------------- generate keyboard input to send to program -----
if ($OUTFORMAT == "l" | $OUTFORMAT == "m" | $OUTFORMAT == "j" | $OUTFORMAT == "f" | \
    $OUTFORMAT == "a" | $OUTFORMAT == "z" | $OUTFORMAT == "p" | $OUTFORMAT == "x" | \
    $OUTFORMAT == "v" | $OUTFORMAT == "e" | $OUTFORMAT == "c" | $OUTFORMAT == "t" | \
    $OUTFORMAT == "o" | $OUTFORMAT == "b" ) then
    # choose an output file format
    echo  P >> PARAMFILE 
    echo $OUTFORMAT >> PARAMFILE 

    # some output formats require additional specifications
    switch ($OUTFORMAT)
      case "j":     # Hewlett Packard Laserjet
	echo n >> PARAMFILE 
	echo 2 >> PARAMFILE         #Resolution 150 dpi
	breaksw
      case "p":     # PC Paintbrush PCX format
	echo n >> PARAMFILE 
	echo 3 >> PARAMFILE        #Resolution VGA 1024 x 768
	breaksw
      case "x":     #X11 bitmap
	echo n >> PARAMFILE
	echo 1024 >> PARAMFILE      #X resolution
	echo 512  >> PARAMFILE       #Y resolution
	breaksw
      default :      # all others, no extra specs. needed         
	breaksw
    endsw
endif

# Turn off X-windows display
echo v >> PARAMFILE 
echo n >> PARAMFILE 

# Tree parameters
if ($TORIENT == v) echo h >> PARAMFILE 

echo s >> PARAMFILE 
echo $TSTYLE >> PARAMFILE 

if ($USELEN == no) echo b >> PARAMFILE 

echo l >> PARAMFILE 
echo $LANGLE >> PARAMFILE 

echo d >> PARAMFILE 
echo $DBRATIO >> PARAMFILE 

echo t >> PARAMFILE 
echo $LDRATIO >> PARAMFILE 

echo c >> PARAMFILE 
echo $CHARHEIGHT >> PARAMFILE 

echo a >> PARAMFILE 
echo $ANCESTNODE >> PARAMFILE 

echo y >> PARAMFILE    #accept current settings and write plotfile

#---------------------  Run Drawgram ----------------------
cp $FONTFILE fontfile
nice +10 drawgram < PARAMFILE

mv plotfile ../$OUTFILE
cd ..
$RM_CMD -rf $TEMPDIR



