#!/bin/csh
# This script is called for files listed in .GDEmenus files
# using openitem:

# It chooses a viewer, depending on the file extension.
# Mime might be the 'right' way to do this, but it's
# immensly easier to just write a short script, and probably
# more reliable.

# In most cases the file extension tells us what to do with
# the file. However, we also want to be able to correctly handle
# a URL, so URL tells us if $1 is a URL, rather than a local
# file name. 
set EXT = $1:e


set URLFLAG = `echo $1 | egrep -e '^http:|^https:|^ftp:|^ftps:'`
if ($URLFLAG != "") set EXT = "html"

switch ($EXT)
  # -------- Web pages
  case "html": 
        browser.csh $1 &
    breaksw
  case "shtml": 
        browser.csh $1 &
    breaksw
  case "HTML": 
        browser.csh $1 &
    breaksw
  case "htm": 
        browser.csh $1 &
    breaksw    
  case "HTM": 
        browser.csh $1 &
    breaksw
  # -------- PDF, PostScript
  case "pdf": 
    $GDE_PDFVIEW $1 &
    breaksw
  case "PDF": 
    $GDE_PDFVIEW $1 &
    breaksw
  case "ps": 
    $GDE_PSVIEW $1 &
    breaksw
  case "PS": 
    $GDE_PSVIEW $1 &
    breaksw
  # -------- Bitmap graphics
  case "GIF": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "gif": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "JPG": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "jpg": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "JPEG": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "jpeg": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "PNG": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "png": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "BMP": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "bmp": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "TIF": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "tif": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw    
  case "TIFF": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw  
  case "tiff": 
    $GDE_BITMAP_VIEWER $1 &
    breaksw    
  # -------- Default is text editor
  default: 
   # Special code for text editors used by GDE and scripts called by GDE
   # Nedit crashes in some Linux systems due to libraries set in BIRCHLIBS.
   # nedit_wrapper unsets LD_LIBRARY_PATH before calling nedit.
   # gedit opens all files in a single window. gedit_wrapper.sh forces
   # gedit to open each file in different window.
   # choose_edit_wrapper.sh returns the name of the wrapper to use
   # for each editor, or just returns GDE_TEXTEDIT if there is no
   # wrapper.
   setenv GDE_TEXTEDIT `choose_edit_wrapper.sh`  
   $GDE_TEXTEDIT $1 &
    breaksw
endsw

