#!/bin/sh
# Wrapper for gedit. Forces gedit to open a new
# window for each file.

# RM_CMD - command to be used for removing files and directories
if [ -f /usr/bin/rm ]
then
   RM_CMD=/usr/bin/rm
else
   if [ -f /bin/rm ]
   then
      RM_CMD=/bin/rm
   else
      RM_CMD=rm
   fi
fi

# This is harder than it sounds. If we just try to open each 
# new file in a new window using '--new-window',
# while other threads of gedit are running, for some 
# reason, gedit can't get to the file before it is deleted by GDE.
# The workaround is to rename the file 
# gedit is a stupidly dumbed down program. The only 
# reason we are using it is that it is probably the most
# commonly-distributed text editor in Linux. 
#
# Renaming the file creates a new problem, being that 
# we now need to explicitly remove the temporary file.
# If we do that too quickly, gedit doesn't have time to
# find the temporary file and read it into memory. Therefore,
# we need to make the script sleep a bit before removing
# the temporary file.
# What a hack!
GEDIT_COMMAND=`which gedit`
cp $1 tmp_$$
$GEDIT_COMMAND --new-window tmp_$$ 
sleep 5
$RM_CMD -f tmp_$$

