#!/bin/csh

# Top directory for your lab database
setenv ACEDB $BIRCH/local-generic/public_html/birchdb
#setenv ACEDB_COMMON $ACEDB

# Directory to contain the binary database file
setenv DBDIR $ACEDB/database

# Directory for executable code specific for your database
# eg. this script
setenv BINDIR $ACEDB/bin

# Run xace, and call cleanup.csh to make sure all files
# have correct group membership and permissions.
#set path = ($BINDIR $BIRCH/acedb/bin $path)
set path = ($BINDIR $path)

setenv ACE_FILE_LAUNCHER $BINDIR/chooseviewer


# Use this for a more diverse server cluster
# Platform-specific setup commands
setenv BIRCHLIBS  ""
switch ($BIRCH_PLATFORM)
  case "solaris-sparc":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc"
    breaksw 
  case "solaris-amd64":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-amd64:$BIRCH/local/lib-solaris-amd64"
    breaksw    
  case "sun":   # DEPRECATED
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc"
    breaksw
  case "linux-intel":
    setenv BIRCHLIBS $BIRCH/lib-linux-intel:$BIRCH/lib-linux-intel/openwin/lib:$BIRCH/local/lib-linux-intel
    breaksw
  case "linux-x86_64":
    setenv BIRCHLIBS $BIRCH/lib-linux-x86_64:$BIRCH/lib-linux-x86_64/openwin/lib:$BIRCH/local/lib-linux-x86_64
    breaksw
  case "osx-x86_64":
    setenv BIRCHLIBS $BIRCH/lib-osx-x86_64:$BIRCH/local/lib-osx-x86_64
    breaksw
#  case "AIX":
#    breaksw
#  case "HP":
    breaksw
  default:
    breaksw
endsw

#echo BIRCHLIBS $BIRCHLIBS
if ( "$BIRCHLIBS" != "" ) then
   if ${?LD_LIBRARY_PATH} then
      setenv LD_LIBRARY_PATH "$LD_LIBRARY_PATH":"$BIRCHLIBS"
   else
      setenv LD_LIBRARY_PATH "$BIRCHLIBS"
   endif
endif

if ( $BIRCH_PLATFORM == "osx-x86_64" ) then
   setenv DYLD_LIBRARY_PATH "$LD_LIBRARY_PATH"
   echo DYLD_LIBRARY_PATH "$DYLD_LIBRARY_PATH"
endif
#echo LD_LIBRARY_PATH $LD_LIBRARY_PATH

(xace; $BINDIR/cleanup.sh)&
