#!/usr/local/bin/python
# Feb.  5, 2005, Dr. Brian Fristensky, University of Manitoba

# Description: Convert a file of tokens to a GDE
# flat file. The input file contains a single nonblank
# string on each line.

# Synopsis: list2flat.py infile outfile

# Files: infile      file of tokens
#        outfile     GDE flat file, containing a comma separated
#                    list of tokens

import sys
import os
import string

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Read in old and new strings, striping 
# leading and trailing whitespace, including
# newline characters.
def GETLIST(FN) :
    LST = []
    FILE = open(FN,'r')
    LINE = FILE.readline()
    while LINE != '':
          LST.append(LINE.strip("\s"))
	  LINE = FILE.readline()
    FILE.close()
    return LST

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Write the list as a single line of comma-separated values
def WRITEGDELIST(FN,LST) :
    if len(LST) > 0:
       LINE = LST[0]
       for i in range(1,len(LST)) :
           LINE = LINE + "," + LST[i]
       LINE = LINE + '\n'	   

       OUTFILE.write(LINE)

    
#======================== MAIN PROCEDURE ==========================

#---------- Set global variables
IFN = sys.argv[1]
OFN = sys.argv[2]
OUTFILE = open(OFN,'w')

# Read in list of tokens
if os.path.exists(IFN) :
   IDLIST = GETLIST(IFN)

   # The first line of a GDE flatfile is the a name line
   # beginning with the double quote character "
   NAMELINE = '"' + IFN + '\n'
   OUTFILE.write(NAMELINE)

   #Write the list as a single line of comma-separated 
   # values
   WRITEGDELIST(OUTFILE,IDLIST)

OUTFILE.close()



