#!/bin/bash

#Version 3/22/10
# Creates an input file form primer3
#Synopsis: primer.csh infile maxprimers optlen minlen maxlen opttemp mintemp
#  maxtemp mingc maxgc saltconc dnaconc minunk maxself max3pself gcclamp
#  minprod maxprod intoligo iopttemp imintemp
#  imaxtemp imingc imaxgc isaltconc idnaconc iminunk imaxself imax3pself

#Convert arguments to variables
# bash will only take arguments such as $1 through $9. $10, $11 etc. aren't allowed.
# We have to enclose the entire environment variable name in braces.
INFILE=${1}
MAXPRIMERS=${2}
OPTLEN=${3}
MINLEN=${4}
MAXLEN=${5}
OPTTEMP=${6}
MINTEMP=${7}
MAXTEMP=${8}
MINGC=${9} 
MAXGC=${10}
SALTCONC=${11}
DNACONC=${12}
MAXUNK=${13}
MAXSELF=${14}
MAX3PSELF=${15}
GCCLAMP=${16}
MINPROD=${17}
MAXPROD=${18}
intoligo=${19}
ioptlen=${20}
iminlen=${21}
imaxlen=${22}
iopttemp=${23}
imintemp=${24}
imaxtemp=${25}
imingc=${26}
imaxgc=${27}
isaltconc=${28}
idnaconc=${29}
imaxunk=${30}
imaxself=${31}
imax3pself=${32}


PID=$$ #process id


# RM_CMD - command to be used for removing files and directories
if [ -e /usr/bin/rm ]
	then
   RM_CMD=/usr/bin/rm
else
   if [ -e /bin/rm ]
   	then
      RM_CMD=/bin/rm
   else
      RM_CMD=rm
   fi
fi


# Determine the size of seq.
btail.sh 2 $INFILE TEMP.$PID
TOTALCHAR=`wc -c < TEMP.$PID` 
NEWLINES=`wc -l < TEMP.$PID`
SEQLENGTH=`expr ${TOTALCHAR} - ${NEWLINES}`


#Write the sequence name
#NAME=`head -1 $INFILE |tr -d '#'`
echo PRIMER_SEQUENCE_ID=$INFILE

#Write the sequence one one long line
# Incredibly, PRIMER3 can't handle RNA, so we change U's to T's.
btail.sh 2 $INFILE TEMPSEQ1.$PID
cat TEMPSEQ1.$PID | tr "U" "T" | tr "u" "t" > TEMPSEQ2.$PID 
echo 'SEQUENCE='`cat TEMPSEQ2.$PID` | tr -d "\n" 
#Make sure sequence ends with a \n
echo ""

# Make sure parameters are reasonable
if  [ ${MINPROD} -gt ${MAXPROD} ]
    then
    MINPROD=$MAXPROD
fi

if [ ${MINPROD} -gt ${SEQLENGTH} ]
   then 
   MINPROD=$SEQLENGTH
fi

if [ ${MAXPROD} -lt ${MINPROD} ]
   then
   MAXPROD=$MINPROD
fi

if [ ${MAXPROD} -gt ${SEQLENGTH} ]
   then
   MAXPROD=$SEQLENGTH
fi

# Write parameters

 # Global parameters
 echo PRIMER_NUM_RETURN=$MAXPRIMERS
 echo PRIMER_OPT_SIZE=$OPTLEN
 echo PRIMER_MIN_SIZE=$MINLEN
 echo PRIMER_MAX_SIZE=$MAXLEN
 echo PRIMER_OPT_TM=$OPTTEMP
 echo PRIMER_MIN_TM=$MINTEMP
 echo PRIMER_MAX_TM=$MAXTEMP
 echo PRIMER_MIN_GC=$MINGC
 echo PRIMER_MAX_GC=$MAXGC
 echo PRIMER_SALT_CONC=$SALTCONC
 echo PRIMER_DNA_CONC=$DNACONC
 echo PRIMER_NUM_NS_ACCEPTED=$MAXUNK
 echo PRIMER_SELF_ANY=$MAXSELF
 echo PRIMER_SELF_END=$MAX3PSELF
 echo PRIMER_GC_CLAMP=$GCCLAMP
 echo PRIMER_DEFAULT_PRODUCT=$MINPROD-$MAXPROD
 echo PRIMER_LIBERAL_BASE=1
 echo PRIMER_FILE_FLAG=1
 echo PRIMER_EXPLAIN_FLAG=1

 # Internal oligo parameters
 if [ $intoligo != 0 ]
      then
    echo PRIMER_PICK_INTERNAL_OLIGO=$intoligo
    echo PRIMER_INTERNAL_OLIGO_OPT_SIZE=$ioptlen
    echo PRIMER_INTERNAL_OLIGO_MIN_SIZE=$iminlen
    echo PRIMER_INTERNAL_OLIGO_MAX_SIZE=$imaxlen
    echo PRIMER_INTERNAL_OLIGO_OPT_TM=$iopttemp
    echo PRIMER_INTERNAL_OLIGO_MIN_TM=$imintemp
    echo PRIMER_INTERNAL_OLIGO_MAX_TM=$imaxtemp
    echo PRIMER_INTERNAL_OLIGO_MIN_GC=$imingc
    echo PRIMER_INTERNAL_OLIGO_MAX_GC=$imaxgc
    echo PRIMER_INTERNAL_OLIGO_SALT_CONC=$isaltconc
    echo PRIMER_INTERNAL_OLIGO_DNA_CONC=$idnaconc
    echo PRIMER_INTERNAL_OLIGO_NUM_NS_ACCEPTED=$imaxunk
    echo PRIMER_INTERNAL_OLIGO_SELF_ANY=$imaxself
    echo PRIMER_INTERNAL_OLIGO_SELF_END=$imax3pself
 fi

# Terminate record
echo '='

# Delete temporary files
$RM_CMD -f *.$PID $INFILE

