#!/bin/bash

#Version 3/26/10
# Run primer3 using the input file created by primer3.csh
#Synopsis: primer3run.csh infile 

#Convert arguments to variables
INFILE=$1
NAME=${INFILE%*.*}



# RM_CMD - command to be used for removing files and directories
if [ -e /usr/bin/rm ]
	then
   RM_CMD=/usr/bin/rm
else
   if [ -e /bin/rm ]
   	then
      RM_CMD=/bin/rm
   else
      RM_CMD=rm
   fi
fi

nice -n 10 cat $INFILE | primer3_core -format_output > $NAME.out

$RM_CMD $INFILE

# Special code for text editors used by GDE and scripts called by GDE
# Nedit crashes in some Linux systems due to libraries set in BIRCHLIBS.
# nedit_wrapper unsets LD_LIBRARY_PATH before calling nedit.
# gedit opens all files in a single window. gedit_wrapper.sh forces
# gedit to open each file in different window.
# choose_edit_wrapper.sh returns the name of the wrapper to use
# for each editor, or just returns GDE_TEXTEDIT if there is no
# wrapper.
GDE_TEXTEDIT=`choose_edit_wrapper.sh`
export GDE_TEXTEDIT 
($GDE_TEXTEDIT $NAME.out; $RM_CMD $NAME.out) &
($GDE_TEXTEDIT $NAME.for; $RM_CMD $NAME.for) & 
($GDE_TEXTEDIT $NAME.rev; $RM_CMD $NAME.rev) &
if [ -e $NAME.int ]
   then
   ($GDE_TEXTEDIT $NAME.int; $RM_CMD $NAME.int) &
fi


