#!/bin/csh

#Version 5/23/08
# Run primer3 using the input file created by primer3.csh
#Synopsis: primer3run.csh infile 

#Convert arguments to variables
set INFILE     = $1
set NAME       = $INFILE:r

set PID = $$ #process id

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

nice +10 cat $INFILE | primer3 -format_output > $NAME.out

$RM_CMD $NAME

# Special code for text editors used by GDE and scripts called by GDE
# Nedit crashes in some Linux systems due to libraries set in BIRCHLIBS.
# nedit_wrapper unsets LD_LIBRARY_PATH before calling nedit.
# gedit opens all files in a single window. gedit_wrapper.sh forces
# gedit to open each file in different window.
# choose_edit_wrapper.sh returns the name of the wrapper to use
# for each editor, or just returns GDE_TEXTEDIT if there is no
# wrapper.
setenv GDE_TEXTEDIT `choose_edit_wrapper.sh` 
($GDE_TEXTEDIT $NAME.out; $RM_CMD $NAME.out) &
($GDE_TEXTEDIT $NAME.for; $RM_CMD $NAME.for) & 
($GDE_TEXTEDIT $NAME.rev; $RM_CMD $NAME.rev) &
if (-e $NAME.int) ($GDE_TEXTEDIT $NAME.int; $RM_CMD $NAME.int) &


# Delete temporary files
$RM_CMD *.$PID
$RM_CMD $NAME.in

