#!/bin/csh

#Version  02/17/2003
#Synopsis: retree.csh infile rooted outfile

# Run retree as a command

#Convert arguments to variables
set INFILE      = $1
set ROOTED      = $2
set OUTFILE     = $3

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

# Make a temporary directory to run the program in 
set TEMPDIR = RETREE.$$
mkdir $TEMPDIR
cp $INFILE $TEMPDIR/intree
cd $TEMPDIR

#----------------- generate keyboard input to send to program -----

#accept default settings proceed to next menu
echo y  >> PARAMFILE

# Tell retree to write tree to outfile
echo w >> PARAMFILE

# Should tree be rooted?
if ($ROOTED ==  y) then
   echo r >> PARAMFILE
else
   echo u >> PARAMFILE
endif

#quit the program
echo q  >> PARAMFILE


#-------- Run retree, sending terminal output to /dev/null -----------
# high nice level is set just in case we do get an infinite loop
# Remember, retree reads a file called intree, and writes to outtree
nice +10 retree < PARAMFILE > /dev/null
mv  -f outtree ../$OUTFILE
cd ..
$RM_CMD -r $TEMPDIR






