#!/usr/local/bin/ruby
# This Ruby script is used by Seahawk to render exported workflow previews (see ca.ucalgary.seahawk.gui.MobySaveDialog), and should be hosted at MobySaveDialog.PNG_GENERATOR_URL

# Contents is the output for a T2Flow document (Taverna workflow) visualized 
# using myExperiment.org gems and 'dot'.  The workflow should be posted as a parameter called 'workflow'
require 'cgi'
require 'rubygems'
require 't2flow/model.rb' # these gems are available from http://github.com/mannie/taverna2-gem/
require 't2flow/parser.rb'
require 't2flow/dot.rb'

# Create an instance of CGI
cgi = CGI.new

# HTTP response headers, including double newline
print "Content-type: image/png\n\n"

# give dot the input (model) to render
dot = IO.popen("/opt/csw/bin/dot -Tpng", "wb+")
T2Flow::Dot.new.write_dot(dot, T2Flow::Parser.new.parse(cgi['workflow']))

# terminate processing
dot.close_write
dot.each {|l| puts l}
