package ca.ucalgary.seahawk.util;

import java.io.File;
import javax.swing.filechooser.FileFilter;

/**
 * A FileFilter used to provide meaningful extensions and descriptions when using a file dialog.
 */
public class DescriptiveFileFilter extends FileFilter {
    
    /** The extension of the image filename. */
    protected String extension;
    protected String desc;
    
    public DescriptiveFileFilter(String extension, String desc) {
	this.extension = extension;
	this.desc = desc;
    }
    
    /**
     * Returns true if <tt>f</tt> is a file with the correct extension,
     * false otherwise.
     */
    public boolean accept(File f) {
	boolean accept = false;
	String fileName = null;
	if (f != null) {
	    if (f.isDirectory()) {
		accept = true;
	    } else {
		fileName = f.getPath().toLowerCase();
		if (fileName.endsWith(extension)) {
		    accept = true;
		}
	    }
	}
	return accept;
    }
    
    /**
     * Returns the file description
     */
    public String getDescription() {
	return desc;
    }
}
