package ca.ucalgary.seahawk.util;

import org.biomoby.shared.*;
import org.biomoby.shared.data.*;
import org.biomoby.shared.parser.MobyTags;

/**
 * A class that pretends it's a real moby data instance, but is actually a deferred list of data instances
 * that should be submitted en-masse to services.  Use to implement 'for each' functionality in Seahawk.
 */
public class MobyDataObjectDeferred extends MobyDataComposite implements MobyContentCreator{
    private MobyPayloadRequestListener dataCreator;

    public MobyDataObjectDeferred(MobyNamespace ns, MobyPayloadRequestListener listener) throws Exception{
	super(MobyDataType.getDataType(MobyTags.MOBYOBJECT, SeahawkOptions.getRegistry()), ns, "any_id");
	dataCreator = listener;
    }
    public MobyDataObjectDeferred(MobyDataType dt, MobyPayloadRequestListener listener) throws Exception{
	super(dt, new MobyNamespace("unknown"), "any_id");
	dataCreator = listener;
    }
    public MobyDataObjectDeferred(MobyDataType dt, MobyNamespace ns, MobyPayloadRequestListener listener) throws Exception{
	super(dt, ns, "any_id");
	dataCreator = listener;
    }

    public MobyContentInstance getAllContents(String jobParamName){
	return dataCreator.createPayload(jobParamName);
    }
}