package ca.ucalgary.seahawk.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JTextPane;
import javax.swing.RepaintManager;

/**
 * A class used to make the rendered contents of a JEditorPane printable in Java.
 *
 * @author Paul Gordon (gordonp@ucalgary.ca)
 */
public class PrintableJEditorPane extends JTextPane implements Printable{

    public int print (Graphics g, PageFormat pf, int pageIndex) throws PrinterException{
	Graphics2D g2 = (Graphics2D) g;
	g2.setColor (java.awt.Color.black);
	
	RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
	Dimension d = this.getSize();
	double panelWidth = d.width;
	double panelHeight = d.height;
	double pageWidth = pf.getImageableWidth();
	double pageHeight = pf.getImageableHeight();
	double scale = pageWidth / panelWidth;
	int totalNumPages = (int)Math.ceil(scale * panelHeight /
					   pageHeight);
	
	// Check for empty pages
	if (pageIndex >= totalNumPages) return Printable.NO_SUCH_PAGE;
	
	g2.translate(pf.getImageableX(), pf.getImageableY());
	g2.translate(0f, -pageIndex * pageHeight);
	g2.scale(scale, scale);
	this.paint(g2);
	RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
	
	return Printable.PAGE_EXISTS;
    }
}
