package embl.ebi.trace;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.zip.*;
import java.net.URL;
import org.omg.CORBA.*;
import org.omg.CosNaming.*;	// Uses Name Service


/** 
This applet/application is the client side of a CORBA based client server architecture for
serving and displaying individual DNA sequence chromatograms (traces).
I hacked Eugen Buehler's original applet about to use org.omg.CORBA methods to provide the 
input instead of a file and to allow new traces to be loaded and to speed up 
or tidy up a few original features. 
The applet/application needs a few parameters to find the CORBA server etc.
If you want to view traces without using  client/server CORBA architecture
see the other applications including TraceView
@see ChromatogramViewer
@see CorbaChromatogramWrapper
@see TraceStore
@see TraceView
@author Eugen Buehler buehler@agave.humgen.upenn.edu
@author Jeremy D. Parsons jparsons@ebi.ac.uk
*/
/*************************************************************************

Copyright (c) 1998 by European Bioinformatics Institute, Cambridge, UK.


You are hereby granted permission to use, copy, modify, and distribute 
this software and its documentation for any purpose and without fee,
provided that the above copyright notices appear in all copies and that 
both the above copyright notices and this permission notice appear in 
supporting documentation, and that neither the name of the European 
Molecular Biology Laboratory nor European Bioinformatics Institute are 
used in advertising or publicity pertaining to distribution of the 
software without specific written prior permission. You HEREBY AGREE 
THAT SINCE THE FOREGOING LICENCE IS GRANTED WITHOUT CHARGE, IT IS 
REASONABLE THAT THIS SOFTWARE IS PROVIDED "AS IS" AND THAT THE 
EUROPEAN MOLECULAR BIOLOGY LABORATORY AND EUROPEAN BIOINFORMATICS 
INSTITUTE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF 
SATISFACTORY QUALITY OR FITNESS FOR A PARTICULAR PURPOSE, AND IN NO 
EVENT SHALL THE EUROPEAN MOLECULAR BIOLOGY LABORATORY OR EUROPEAN 
BIOINFORMATICS INSTITUTE BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT 
(INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN 
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

*************************************************************************/

public class CorbaChromatogramApplet extends Applet {
	NamingContext		rootContext = null;
	CorbaChromatogramWrapper	viewerCore = null;
	
	public void init() {
		super.init();
		UserComms.applet = this;	// Configure the messaging options
		String	iorFilename;
		try	{
			UserComms.inform("Binding to the ORB");
			org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(this, null);

			// Bind to the server's Naming Service and get the trace server names from there
			UserComms.inform("Binding to the remote Name Service Object");

			try	{
				iorFilename = getCodeBase() + getParameter("naming.ior");
				rootContext = NamingContextHelper.narrow(IOR2Object(orb, iorFilename));
				}
			catch (org.omg.CORBA.COMM_FAILURE ex){
				showStatus("Communication failed. Is the server running ? " + ex.getMessage());
				}
			}
		catch (org.omg.CORBA.SystemException ex){
			showStatus("Applet Exception: " + ex);
			System.err.println("Applet Exception: " + ex);
			}

		this.setLayout(new BorderLayout());
		viewerCore = new CorbaChromatogramWrapper();
		viewerCore.setRootContext(rootContext);
		this.add("Center", (Panel)viewerCore);

		// reloadTrace("WUGSC", "ya01c08.s1");
		String storeName = getParameter("DefaultTraceStore");
		String traceName = getParameter("DefaultTrace");
		if ((storeName != null) && (traceName != null)){
			TraceRequestEvent firstTraceCall = new TraceRequestEvent((Applet)this, storeName, traceName);
			viewerCore.traceRequested(firstTraceCall);
			}
	
		}

	public static void main(String args[]) {
		Frame			mainFrame = new Frame("DNA Sequence Chromatogram Viewer");
		CorbaChromatogramWrapper viewerCore = null;
		String			iorUrl;
		NamingContext		rootContext = null;
		String			storeName = null;
		String			traceName = null;

		if (args.length < 1) {
			System.err.println("Usage: java CorbaChromatogramApplet URL(of remote naming service IOR) [store_name trace_name]");
			System.exit(1);
			}
		iorUrl = args[0];
		if (args.length == 3) {
			// Assume been given a trace name and a store name
			storeName = args[1];
			traceName = args[2];
			}

		try	{
			UserComms.inform("Binding to the ORB");
			org.omg.CORBA.ORB orb = ORB.init(args, new java.util.Properties());

			// Bind to the server's Naming Service and get the trace server names from there
			UserComms.inform("Binding to the remote Name Service Object");
			rootContext = NamingContextHelper.narrow(IOR2Object(orb, iorUrl));
			}
		catch (org.omg.CORBA.COMM_FAILURE ex){
			UserComms.warn("Communication failed. Is the server running ? " + ex.getMessage());
			}
		catch (Exception ex){
			UserComms.warn("Problem connecting to naming service " + ex.getMessage());
			}
		if (rootContext == null){
			UserComms.warn("Error narrowing Naming Service reference");
			System.exit(-1);
			}

		WindowListener winListener = new WindowAdapter(){
			public void windowClosing(WindowEvent e) {System.exit(0);}
			};
		mainFrame.addWindowListener(winListener);

		viewerCore = new CorbaChromatogramWrapper();
		viewerCore.setRootContext(rootContext);
		mainFrame.add(viewerCore);
		if (traceName != null){
			TraceRequestEvent firstTraceCall = new TraceRequestEvent(mainFrame, storeName, traceName);
			viewerCore.traceRequested(firstTraceCall);
			}
		mainFrame.pack();
		mainFrame.setVisible(true);
		}

	public static org.omg.CORBA.Object IOR2Object(ORB orb, String refURLStr){
		BufferedReader  in;
		URL             url;
		String          ior;
		org.omg.CORBA.Object obj;

		obj = null;
		try	{
			url = new URL(refURLStr);
			in = new BufferedReader(new InputStreamReader(url.openStream()));
			ior = in.readLine();
			obj = orb.string_to_object(ior);
			in.close();
			}
		catch (java.net.MalformedURLException ex) {
			UserComms.warn(("The URL did not work: " + ex.getMessage()));
			}
		catch (IOException ex) {
			UserComms.warn(("Connection failed: " + ex.getMessage()));
			}
		if (obj == null){
			UserComms.warn("Error getting object reference from: " + refURLStr);
			}

		return(obj);
		}

	
	public String [][] getParameterInfo() {
		String [][] appletInfo =
			{
			{"DefaultTraceStore", "String", "Name of the databank that holds a DNA sequence trace"},
			{"DefaultTrace", "String", "Accession number of the particular DNA trace of interest"},
			{"naming.ior", "String", "Name of the file containing the server's naming service IOR"}
			};
		return(appletInfo);
		}

	public String getAppletInfo() {
		return("DNA sequence trace viewer developed by Jeremy Parsons (jparsons@ebi.ac.uk)" +
			" and Eugen Buehler (snafu@telerama.lm.com)"
			);
		}

}
