<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:output method = "html" omit-xml-declaration = "yes" indent = "yes" />

<xsl:template match="com.skaringa.perftest.config.PerfTestSuiteParams">
    <html>
    	<head>
		<title><xsl:value-of select="name/."/></title>
	</head>
	<body>
 		<h1><xsl:value-of select="name/."/></h1>
 		<h4><xsl:value-of select="comment/."/></h4>
 		<table>
 			<tr><td><b>Testclass:</b></td><td><xsl:value-of select="testclass/."/></td></tr>
 			<tr><td><b>Parallel:</b></td><td><xsl:value-of select="parallel/."/></td></tr>
			<tr><td><b>Date:</b></td><td><xsl:value-of select="testDate/."/></td></tr>
			<tr><td><b>Hardware:</b></td><td><xsl:value-of select="hardware/."/></td></tr>
			<tr><td><b>OS:</b></td><td><xsl:value-of select="os/."/></td></tr>
			<tr><td><b>JVM:</b></td><td><xsl:value-of select="jvm/."/></td></tr>
 		</table>
 		<p>
 		<table border="1">
 			<tr>
 				<th>Method</th>
 				<th>Data type</th>
 				<th>Data size [elements]</th>
                <th>Random data</th>
                <th>Average time per test [ms]</th>
            </tr>
 		
 		<xsl:apply-templates select="perftests/el"/>
 		
 		</table>
     	</p>
     </body>
    </html>
</xsl:template>

<xsl:template match="el">
 	<tr>
 			<td><xsl:value-of select="method/."/></td>
 			<td><xsl:value-of select="dataType/."/></td>
 			<td align="right"><xsl:value-of select="dataSize/."/></td>
 			<td><xsl:value-of select="randomData/."/></td>
 			<td align="right">
 			<xsl:if test="error/. = 'true'">FAILED</xsl:if>
 			<xsl:if test="error/. = 'false'"><xsl:value-of select="time/."/></xsl:if>
 			</td>
 	</tr>
</xsl:template>

<!-- ignore all not matched -->
<xsl:template match="*" priority="-1"/>

</xsl:stylesheet>

