/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.main;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.biolegato.main.BLMain;
import org.biolegato.main.PluginWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    public static void loadPlugins(Map<String, PluginWrapper> pluginHash, String directory) {
        String className = "";
        File pluginDirectory = new File(directory);
        if (pluginDirectory.exists() && pluginDirectory.isDirectory()) {
            for (File file : pluginDirectory.listFiles()) {
                try {
                    if (file.exists() && file.canRead() && file.isFile() && file.getName().toLowerCase().endsWith(".class")) {
                        className = file.getName().substring(0, file.getName().length() - 6);
                        PluginLoader.loadClass(pluginHash, pluginDirectory.toURI().toURL(), className);
                        continue;
                    }
                    if (file.exists() && file.canRead() && file.isFile() && file.getName().endsWith(".jar")) {
                        PluginLoader.loadJar(pluginHash, file);
                        continue;
                    }
                    if (!file.exists() || !file.canRead() || !file.isDirectory()) continue;
                    PluginLoader.loadPlugins(pluginHash, file.getAbsolutePath());
                }
                catch (Throwable th) {
                    BLMain.error("Error loading the file: " + file.getAbsolutePath(), "loadPlugins");
                    th.printStackTrace(System.err);
                }
            }
        }
    }

    public static void loadJar(Map<String, PluginWrapper> pluginHash, File file) throws IOException {
        Enumeration<JarEntry> entries = null;
        JarFile jarfile = new JarFile(file);
        JarEntry entry = null;
        String className = "";
        entries = jarfile.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".class")) continue;
            className = entry.getName().substring(0, entry.getName().length() - 6);
            className = className.replace("/", ".");
            PluginLoader.loadClass(pluginHash, file.toURI().toURL(), className);
        }
    }

    public static void loadClass(Map<String, PluginWrapper> pluginHash, URL url, String name) {
        try {
            Class<?> currentClass = new URLClassLoader(new URL[]{url}).loadClass(name);
            if (currentClass != null) {
                pluginHash.put(name, new PluginWrapper(name, currentClass));
                for (Class<?> c : currentClass.getDeclaredClasses()) {
                    PluginLoader.loadClass(pluginHash, url, c.getName());
                }
            }
        }
        catch (Throwable th) {
            BLMain.error("Error loading the class: " + url.getPath() + " (" + name + ")", "Plugin system");
            th.printStackTrace(System.err);
        }
    }
}

