/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.menu;

import java.awt.Container;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biolegato.menu.Widget;

public class NumberWidget
implements Widget,
ChangeListener {
    private int min;
    private int max;
    private int value;
    private String label = null;
    private JSlider slider = null;
    private JSpinner spinner = null;
    private static final long serialVersionUID = 7526472295622776161L;

    public NumberWidget(String label, int min, int max, int value) {
        this.label = label;
        this.min = min;
        this.max = max;
        this.value = value;
    }

    public void stateChanged(ChangeEvent e) {
        this.value = e.getSource() == this.spinner ? ((Number)this.spinner.getValue()).intValue() : this.slider.getValue();
        this.slider.setValue(this.value);
        this.spinner.setValue(this.value);
    }

    public void display(Container dest) {
        Box container = new Box(2);
        if (this.label != null) {
            container.add(new JLabel(this.label));
        }
        if (this.slider == null && this.spinner == null) {
            this.spinner = new JSpinner(new SpinnerNumberModel(this.value, this.min, this.max, 1));
            this.spinner.addChangeListener(this);
            this.slider = new JSlider(0, this.min, this.max, this.value);
            this.slider.addChangeListener(this);
            container.add(this.spinner);
            container.add(new JLabel("" + this.min));
        }
        container.add(this.slider);
        container.add(new JLabel("" + this.max));
        dest.add(container);
    }

    public void close() {
        this.slider = null;
        this.spinner = null;
    }

    public Object getValue() {
        return this.value;
    }
}

