/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.ContentModel;
import com.ibm.xml.framework.ContentSpecNode;
import com.ibm.xml.framework.ElementDeclPool;
import com.ibm.xml.framework.InsertableElementsInfo;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLValidationHandler;
import com.ibm.xml.internal.CMException;
import com.ibm.xml.internal.DFAContentModel;
import com.ibm.xml.internal.MixedContentModel;
import com.ibm.xml.internal.SimpleContentModel;

public class DefaultValidationHandler
implements XMLValidationHandler {
    private ElementDeclPool fDeclPool = null;
    private XMLErrorHandler fErrHandler = null;
    private AttrPool fAttrPool = null;
    private StringPool fStringPool = null;
    private ParserState fParserState = null;
    private static final boolean DEBUG_PRINT_ATTRIBUTES = false;
    private static final boolean DEBUG_PRINT_CONTENT = false;

    public DefaultValidationHandler(ParserState parserState) {
        this.fDeclPool = parserState.cacheElementDeclPool();
        this.fErrHandler = parserState.getErrorHandler();
        this.fAttrPool = parserState.cacheAttrPool();
        this.fStringPool = parserState.cacheStringPool();
        this.fParserState = parserState;
        boolean bl = this.fDeclPool == null || this.fErrHandler == null || this.fAttrPool == null || this.fStringPool == null || this.fParserState == null;
    }

    public void reset(ParserState parserState) {
        this.fDeclPool = parserState.cacheElementDeclPool();
        this.fErrHandler = parserState.getErrorHandler();
        this.fAttrPool = parserState.cacheAttrPool();
        this.fStringPool = parserState.cacheStringPool();
        this.fParserState = parserState;
    }

    public void checkRootElementName(int elementNameIndex) throws Exception {
        int rootElement = this.fDeclPool.getRootElement();
        if (rootElement == -1) {
            return;
        }
        int rootElementName = this.fDeclPool.getElementName(rootElement);
        if (elementNameIndex != rootElementName) {
            this.fErrHandler.error2(126, rootElementName, elementNameIndex);
        }
    }

    public void checkAttributes(int elementIndex, int firstAttrIndex) throws Exception {
        if (this.fParserState.getCheckNamespace()) {
            this.fDeclPool.checkNamespace(elementIndex, firstAttrIndex);
        }
    }

    public int checkContent(int elementIndex, int childCount, int[] children) throws Exception {
        int elementNameIndex = this.fDeclPool.getElementName(elementIndex);
        int contentSpec = this.fDeclPool.getContentSpecType(elementIndex);
        if (contentSpec == 1) {
            if (childCount != 0) {
                return 0;
            }
        } else if (contentSpec != 2) {
            if (contentSpec == 3 || contentSpec == 4) {
                ContentModel cmElem = null;
                try {
                    cmElem = this.getContentModel(elementIndex);
                    return cmElem.validateContent(childCount, children);
                }
                catch (CMException excToCatch) {
                    excToCatch.send(this.fErrHandler);
                }
            } else if (contentSpec == 0) {
                this.fErrHandler.error1(166, elementNameIndex);
            } else {
                this.fErrHandler.error(152);
            }
        }
        return -1;
    }

    public void checkIDRefNames() throws Exception {
        this.fDeclPool.checkIdRefs();
    }

    public int whatCanGoHere(int elementIndex, boolean fullyValid, InsertableElementsInfo info) throws Exception {
        if (info.insertAt > info.childCount || info.curChildren == null || info.childCount < 1 || info.childCount > info.curChildren.length) {
            this.fErrHandler.error(158);
        }
        int retVal = 0;
        try {
            ContentModel cmElem = this.getContentModel(elementIndex);
            retVal = cmElem.whatCanGoHere(fullyValid, info);
        }
        catch (CMException excToCatch) {
            excToCatch.send(this.fErrHandler);
        }
        return retVal;
    }

    private final ContentModel createChildModel(int elementIndex) throws CMException {
        ContentSpecNode specNode = new ContentSpecNode();
        this.fDeclPool.getContentSpecNode(this.fDeclPool.getContentSpec(elementIndex), specNode);
        if (specNode.value == -1) {
            throw new CMException(159);
        }
        if (specNode.type == 0) {
            return new SimpleContentModel(specNode.value, -1, specNode.type);
        }
        if (specNode.type == 4 || specNode.type == 5) {
            ContentSpecNode specLeft = new ContentSpecNode();
            ContentSpecNode specRight = new ContentSpecNode();
            this.fDeclPool.getContentSpecNode(specNode.value, specLeft);
            this.fDeclPool.getContentSpecNode(specNode.otherValue, specRight);
            if (specLeft.type == 0 && specRight.type == 0) {
                return new SimpleContentModel(specLeft.value, specRight.value, specNode.type);
            }
        } else if (specNode.type == 1 || specNode.type == 2 || specNode.type == 3) {
            ContentSpecNode specLeft = new ContentSpecNode();
            this.fDeclPool.getContentSpecNode(specNode.value, specLeft);
            if (specLeft.type == 0) {
                return new SimpleContentModel(specLeft.value, -1, specNode.type);
            }
        } else {
            throw new CMException(152);
        }
        return new DFAContentModel(elementIndex, this.fStringPool, this.fDeclPool);
    }

    ContentModel getContentModel(int elementIndex) throws CMException {
        ContentModel cmRet = this.fDeclPool.getContentModel(elementIndex);
        if (cmRet != null) {
            return cmRet;
        }
        int contentSpec = this.fDeclPool.getContentSpecType(elementIndex);
        if (contentSpec == 3) {
            cmRet = new MixedContentModel(this.fDeclPool, elementIndex);
        } else if (contentSpec == 4) {
            cmRet = this.createChildModel(elementIndex);
        } else {
            throw new CMException(152);
        }
        this.fDeclPool.setContentModel(elementIndex, cmRet);
        return cmRet;
    }
}

