/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import iubio.bioseq.BaseKind;
import iubio.bioseq.SeqInfo;

class SeqKind
extends SeqInfo {
    public static int kMaxSeqtest = 500;
    public boolean shorttest = true;
    public boolean wantcrc = false;
    protected int na;
    protected int aa;
    protected int po;
    protected int nt;
    protected int nu;
    protected int ns;
    protected int no;
    protected int nd;
    protected int numa;
    protected int numg;
    protected int numc;
    protected int numt;
    protected int testlen;
    protected int maxlen;

    public SeqKind() {
        this.init(0);
    }

    public SeqKind(int maxlen) {
        this.init(maxlen);
    }

    public SeqKind(int maxlen, boolean shorttest, boolean wantcrc) {
        this.shorttest = shorttest;
        this.wantcrc = wantcrc;
        this.init(maxlen);
    }

    public void init(int maxlen) {
        this.na = 0;
        this.aa = 0;
        this.po = 0;
        this.nt = 0;
        this.nu = 0;
        this.nd = 0;
        this.ns = 0;
        this.no = 0;
        this.numa = 0;
        this.numc = 0;
        this.numg = 0;
        this.numt = 0;
        this.basecount = 0;
        this.seqtype = 0;
        this.checksum = 0xFFFFFFFFL;
        this.maxlen = maxlen;
        this.testlen = this.shorttest && (maxlen > kMaxSeqtest || maxlen < 1) ? kMaxSeqtest : maxlen;
    }

    public long getChecksum() {
        return this.checksum ^ 0xFFFFFFFFL;
    }

    public int[] getACGTcounts() {
        int numo = this.basecount - this.numa - this.numc - this.numg - this.numt;
        return new int[]{this.numa, this.numc, this.numg, this.numt, numo};
    }

    public int getKind() {
        this.seqtype = this.basecount < 2 || this.no > 0 || this.po + this.aa + this.na + this.nd == 0 ? (short)0 : (this.po > 0 ? (short)4 : (this.aa == 0 ? (this.na == 0 && this.nd > 0 ? (short)5 : (this.nu > this.nt ? (short)2 : (short)1)) : (this.na > this.aa ? (short)3 : (short)4)));
        return this.seqtype;
    }

    private final boolean testmore() {
        return this.testlen < this.maxlen && this.po == 0 && this.aa == 0 && (this.nd > 0 || this.ns > 0 || this.no > 0);
    }

    private final void add1(int c) {
        ++this.basecount;
        if (BaseKind.isProtonly(c)) {
            ++this.po;
        } else if (BaseKind.isPrimenuc(c)) {
            ++this.na;
            if (BaseKind.isDnanuc(c)) {
                ++this.nt;
            } else if (BaseKind.isRnanuc(c)) {
                ++this.nu;
            }
            switch (c) {
                case 65: 
                case 97: {
                    ++this.numa;
                    break;
                }
                case 67: 
                case 99: {
                    ++this.numc;
                    break;
                }
                case 71: 
                case 103: {
                    ++this.numg;
                    break;
                }
                case 84: 
                case 116: {
                    ++this.numt;
                }
            }
        } else if (BaseKind.isAmino(c)) {
            ++this.aa;
        } else if (BaseKind.isIndel(c)) {
            ++this.nd;
        } else if (BaseKind.isSeqsym(c)) {
            ++this.ns;
        } else if (BaseKind.isAlphaseq(c)) {
            ++this.no;
        }
    }

    private final void addcrc(int c) {
        if (c >= 97 && c <= 122) {
            c -= 32;
        }
        this.checksum = BaseKind.crctab[((int)this.checksum ^ c) & 0xFF] ^ this.checksum >> 8;
    }

    public final void add(byte[] ba, int offset, int len) {
        int i;
        int tlen = Math.min(len, this.testlen);
        for (i = 0; i < tlen; ++i) {
            this.add(ba[offset + i]);
        }
        if (this.testmore()) {
            for (i = tlen; i < this.maxlen; ++i) {
                this.add(ba[offset + i]);
            }
        }
        this.getKind();
    }

    public final void add(char[] ca, int offset, int len) {
        int i;
        int tlen = Math.min(len, this.testlen);
        for (i = 0; i < tlen; ++i) {
            this.add(ca[offset + i]);
        }
        if (this.testmore()) {
            for (i = tlen; i < this.maxlen; ++i) {
                this.add(ca[offset + i]);
            }
        }
        this.getKind();
    }

    public final void add(String s, int offset, int len) {
        int i;
        int tlen = Math.min(len, this.testlen);
        for (i = 0; i < tlen; ++i) {
            this.add(s.charAt(offset + i));
        }
        if (this.testmore()) {
            for (i = tlen; i < this.maxlen; ++i) {
                this.add(s.charAt(offset + i));
            }
        }
        this.getKind();
    }

    public final void add(int c) {
        if (c > 32 && (c < 48 || c > 57)) {
            this.add1(c);
            if (this.wantcrc) {
                this.addcrc(c);
            }
        }
    }
}

