/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.FastHashtable;
import flybase.FastProperties;
import flybase.FastVector;
import iubio.bioseq.SeqRange;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.DocItem;
import iubio.readseq.FeatureItem;
import iubio.readseq.FeatureNote;
import java.util.Enumeration;
import java.util.Hashtable;

class FlatFeatDoc
extends BioseqDocImpl {
    public static final String gnomapprop = "FlatFeatDoc";
    public static final String gnomapvers = "gnomap-version ";
    public static final String flatfeatvers = "flatfeat-version ";
    public static final String featurecmt = "Features for ";
    static final String featheadline1 = "# Feature\tgene\tmap\trange\tid\tdb_xref\tnotes";
    static final String featheadline2 = "Key\tLocation\tQualifiers";
    public String species = "";
    public String chromosome = "";
    public String datadate = "";
    public String datasource = "";
    public static String attribOutSeparator = " ; ";
    private static FastHashtable elabel2keys = new FastHashtable();
    private static FastProperties keys2elabel = new FastProperties();
    public static int kWriteVersion = 2;
    public String sversion;
    public int dataversion = 1;
    int dataline;
    int origin = 1;
    int firstSource;
    Hashtable includeSet = null;
    Hashtable excludeSet = null;
    boolean doinclude;
    boolean doexclude;
    protected static final int kClassFld = 0;
    protected static final int kNameFld = 1;
    protected static final int kMapFld = 2;
    protected static final int kRangeFld = 3;
    protected static final int kIdFld = 4;
    protected static final int kDbxFld = 5;
    protected static final int kNotesFld = 6;
    protected static final int kNvals = 7;
    protected String[] vals = new String[7];
    protected int[] valcols;
    protected String keyvalsep;
    protected int keyvalat;
    protected DocItem accItem;
    protected DocItem idItem;
    int lastkind;
    int partid;
    boolean didtop;

    public static final String getMagicString() {
        return FlatFeatDoc.getMagicString(kWriteVersion);
    }

    public static String getMagicString(int version) {
        return "# flatfeat-version " + String.valueOf(version);
    }

    public static final String getColumnHeader() {
        return FlatFeatDoc.getColumnHeader(kWriteVersion);
    }

    public static String getColumnHeader(int version) {
        switch (version) {
            default: {
                return featheadline2;
            }
            case 1: 
        }
        return featheadline1;
    }

    public FlatFeatDoc() {
    }

    public FlatFeatDoc(BioseqDoc source) {
        super(source);
        this.fFromForeignFormat = !(source instanceof FlatFeatDoc);
    }

    public FlatFeatDoc(String idname) {
        this.addBasicName(idname);
    }

    public void setSourceDoc(BioseqDoc source) {
        super.setSourceDoc(source);
        this.fFromForeignFormat = !(source instanceof FlatFeatDoc);
    }

    public void setIncludeFeats(Hashtable include, Hashtable exclude) {
        this.includeSet = include;
        this.doinclude = this.includeSet != null;
        this.excludeSet = exclude;
        boolean bl = this.doexclude = this.excludeSet != null;
        if (this.doinclude) {
            this.doinclude = false;
            Enumeration en = this.includeSet.keys();
            while (en.hasMoreElements()) {
                Object el = en.nextElement();
                Debug.println("include feat " + el + "=" + this.includeSet.get(el));
                this.doinclude = this.doinclude || "true".equals(this.includeSet.get(el));
            }
        }
    }

    public void addDocLine(String line) {
        FeatureItem fi = this.processLine(line);
        if (fi != null) {
            this.inFeatures = 2;
            this.addFeature(fi);
            this.lastfld = fi.getName();
            this.lastlev = 4;
            if (this.firstSource == 1 && (this.species.length() > 0 || this.chromosome.length() > 0)) {
                String recid = "";
                if (this.species.length() > 0) {
                    recid = this.species;
                }
                if (this.chromosome.length() > 0) {
                    if (recid.length() > 0) {
                        recid = recid + "_";
                    }
                    recid = recid + this.chromosome;
                }
                this.replaceDocField(10, recid);
                ++this.firstSource;
            }
        }
    }

    protected void getColumnVals(String line) {
        int at0 = 0;
        for (int i = 0; i < 7; ++i) {
            if (at0 < 0) {
                this.vals[i] = null;
                continue;
            }
            int at = line.indexOf(9, at0);
            if (at < 0) {
                this.vals[i] = line.substring(at0);
                at0 = -1;
                continue;
            }
            this.vals[i] = line.substring(at0, at);
            at0 = at + 1;
        }
    }

    protected int getFieldColumn2(String fldname) {
        if (fldname == null) {
            return -1;
        }
        if ("feature".equals(fldname = fldname.toLowerCase())) {
            return 0;
        }
        if ("key".equals(fldname)) {
            return 0;
        }
        if ("location".equals(fldname)) {
            return 3;
        }
        if ("range".equals(fldname)) {
            return 3;
        }
        if ("qualifiers".equals(fldname)) {
            return 6;
        }
        if ("notes".equals(fldname)) {
            return 6;
        }
        if ("attributes".equals(fldname)) {
            return 6;
        }
        if ("gene".equals(fldname)) {
            return 1;
        }
        if ("symbol".equals(fldname)) {
            return 1;
        }
        if ("name".equals(fldname)) {
            return 1;
        }
        if ("map".equals(fldname)) {
            return 2;
        }
        if ("id".equals(fldname)) {
            return 4;
        }
        if ("db_xref".equals(fldname)) {
            return 5;
        }
        return -1;
    }

    protected void getColumnKeys2(String line) {
        FastVector cols = new FastVector();
        int at0 = 0;
        int icol = 0;
        while (at0 >= 0) {
            String key;
            int at = line.indexOf(9, at0);
            if (at < 0) {
                key = line.substring(at0);
                at0 = -1;
            } else {
                key = line.substring(at0, at);
                at0 = at + 1;
            }
            int tocol = this.getFieldColumn2(key);
            cols.addElement(new Integer(tocol));
            ++icol;
        }
        this.valcols = new int[cols.size()];
        for (int i = 0; i < cols.size(); ++i) {
            this.valcols[i] = (Integer)cols.elementAt(i);
        }
    }

    protected void getColumnVals2(String line) {
        for (int i = 0; i < 7; ++i) {
            this.vals[i] = null;
        }
        int at0 = 0;
        for (int icol = 0; at0 >= 0 && icol < this.valcols.length; ++icol) {
            String val;
            int at = line.indexOf(9, at0);
            if (at < 0) {
                val = line.substring(at0);
                at0 = -1;
            } else {
                val = line.substring(at0, at);
                at0 = at + 1;
            }
            int valcol = this.valcols[icol];
            if (valcol < 0) continue;
            this.vals[valcol] = val;
        }
    }

    protected void processComment(String line) {
        String key = flatfeatvers;
        int at = line.indexOf(key);
        if (at < 0) {
            key = gnomapvers;
            at = line.indexOf(key);
        }
        if (at >= 0) {
            try {
                this.sversion = line.substring(at + key.length()).trim();
                Debug.println("flatfeat vers=" + this.sversion);
                int vers = Integer.parseInt(this.sversion);
                if (vers > 0) {
                    this.dataversion = vers;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        if (line.indexOf(featurecmt) >= 0) {
            String dtsource = "";
            String dtdate = "";
            at = line.indexOf(featurecmt);
            int e = (line = line.substring(at + featurecmt.length())).indexOf(" from");
            if (e > 0) {
                this.species = line.substring(0, e).trim();
                if ((e = (line = line.substring(e + " from".length())).indexOf("[")) > 0) {
                    dtsource = line.substring(0, e).trim();
                    at = (line = line.substring(e)).indexOf(",");
                    if (at >= 0) {
                        e = line.indexOf("]", at);
                    }
                    if (at >= 0 && e > at) {
                        dtdate = line.substring(at + 1, e).trim();
                    }
                }
            }
            if (dtsource.length() > 0 || dtdate.length() > 0) {
                if (dtsource.length() > 0) {
                    this.datasource = dtsource;
                }
                if (dtdate.length() > 0) {
                    this.datadate = dtdate;
                }
                String dtinfo = "Data source: " + this.datasource;
                if (this.datadate.length() > 0) {
                    dtinfo = dtinfo + ", " + this.datadate;
                }
            }
        }
    }

    protected boolean processNondataLine(String line) {
        if (line.length() == 0) {
            return true;
        }
        if (line.startsWith("#")) {
            this.processComment(line);
            return true;
        }
        if (this.dataversion >= 2 && this.dataline == 0) {
            this.getColumnKeys2(line);
            ++this.dataline;
            return true;
        }
        return false;
    }

    protected FeatureItem processLine(String line) {
        if (this.processNondataLine(line = line.trim())) {
            return null;
        }
        if (this.dataversion >= 2) {
            if (this.dataline == 0) {
                this.getColumnKeys2(line);
            } else {
                this.getColumnVals2(line);
            }
            ++this.dataline;
        } else {
            this.getColumnVals(line);
        }
        String key = null;
        String name = null;
        String map = null;
        String range = null;
        String itemId = null;
        String dbx = null;
        String note = null;
        boolean issource = false;
        boolean noexclude = false;
        block11: for (int i = 0; i < 7; ++i) {
            String v = this.vals[i];
            if (i > 0 && (v == null || "-".equals(v) || v.length() == 0)) continue;
            switch (i) {
                case 0: {
                    if (v == null || "-".equals(v) || v.length() == 0) {
                        return null;
                    }
                    key = v;
                    if (!"source".equals(key)) continue block11;
                    ++this.firstSource;
                    noexclude = true;
                    continue block11;
                }
                case 1: {
                    name = v;
                    if (!"source".equals(key)) continue block11;
                    this.species = v;
                    continue block11;
                }
                case 2: {
                    map = v;
                    if (!"source".equals(key)) continue block11;
                    int ca = v.indexOf("Chr");
                    if (ca >= 0) {
                        v = v.substring(ca + 3).trim();
                    }
                    this.chromosome = v;
                    issource = true;
                    continue block11;
                }
                case 3: {
                    range = v;
                    continue block11;
                }
                case 4: {
                    itemId = v;
                    continue block11;
                }
                case 5: {
                    dbx = v;
                    continue block11;
                }
                case 6: {
                    note = v;
                }
            }
        }
        if (key == null) {
            return null;
        }
        if (!noexclude) {
            if (this.doexclude && "false".equals(this.excludeSet.get(key))) {
                return null;
            }
            if (this.doinclude && !"true".equals(this.includeSet.get(key))) {
                return null;
            }
        }
        FeatureItem item = new FeatureItem();
        SeqRange seqrange = new SeqRange();
        try {
            int oldorig = 1;
            if (!issource) {
                oldorig = seqrange.setDisplayOrigin(this.origin);
            }
            seqrange.parse1(range);
            if (!issource) {
                seqrange.setDisplayOrigin(oldorig);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (itemId != null) {
            item.putNote(new FeatureNote("ID", itemId));
        }
        if (name != null) {
            item.putNote(new FeatureNote("name", name));
        }
        if (map != null) {
            item.putNote(new FeatureNote("map", map));
        }
        if (dbx != null) {
            this.getDbxRefs(item, dbx, key);
        }
        if (note != null) {
            this.getQualifiers(item, note, key);
        }
        item.set(key, seqrange);
        return item;
    }

    protected void getQualifiers(FeatureItem item, String s, String featkey) {
        int at0 = 0;
        while (at0 >= 0) {
            String key;
            String val = "";
            int len = s.length();
            int at = s.indexOf(61, at0);
            if (at < 0) {
                at = s.indexOf(32, at0);
            }
            if (at < 0) {
                key = s.substring(at0);
                at0 = -1;
            } else {
                key = s.substring(at0, at);
                at0 = at + 1;
            }
            key = key.trim();
            if (at0 > 0) {
                int e = -1;
                at = -1;
                for (int i = at0; i > 0 && i < len && at < 0; ++i) {
                    char c = s.charAt(i);
                    if (c == '\"') {
                        i = s.indexOf(c, i + 1);
                        continue;
                    }
                    if (c == '\'') {
                        i = s.indexOf(c, i + 1);
                        continue;
                    }
                    if (c != ';' && c != ',' && c != ' ') continue;
                    at = i;
                    while (i < len && e < 0) {
                        c = s.charAt(i);
                        if (c == '/' || Character.isLetterOrDigit(c)) {
                            e = i;
                        }
                        ++i;
                    }
                    if (e >= 0) continue;
                    e = len;
                }
                if (at > 0) {
                    val = s.substring(at0, at);
                    at0 = e;
                } else {
                    val = s.substring(at0);
                    at0 = -1;
                }
                val = val.trim();
            }
            if (key.length() <= 0) continue;
            String akey = key;
            if (!key.startsWith("/")) {
                key = "/" + key;
            }
            FeatureNote fnote = new FeatureNote(key, val);
            item.putNote(fnote);
        }
    }

    protected void getDbxRefs(FeatureItem item, String s, String key) {
        int at0 = 0;
        while (at0 >= 0) {
            String val;
            int at = s.indexOf(44, at0);
            if (at < 0) {
                val = s.substring(at0);
                at0 = -1;
            } else {
                val = s.substring(at0, at);
                at0 = at + 1;
            }
            if ((val = val.trim()).length() <= 0) continue;
            item.putNote(new FeatureNote("db_xref", val));
        }
    }

    public void addDocField(String field, String val, int level, boolean append) {
        int kind = 0;
        if (level == 1 || level == 2 || level == 3) {
            kind = this.getBiodocKind(field);
            switch (kind) {
                case 80: 
                case 90: {
                    level = 1;
                    append = false;
                    break;
                }
            }
        }
        super.addDocField(field, val, kind, level, append);
    }

    protected boolean writeKeyValue(DocItem di) {
        if (this.lastkind == 70) {
            return true;
        }
        String lab = this.getFieldLabel(di);
        String val = this.getFieldValue(di);
        if (lab != null) {
            if (this.keyvalat > 0 && this.keyvalsep != null) {
                this.pr.print(this.keyvalsep);
            }
            ++this.keyvalat;
            this.pr.print(lab);
            val = val.replace('\n', ' ');
            this.pr.print(val);
            return true;
        }
        return false;
    }

    protected void writeFeatureVers1(FeatureItem fi) {
        int i;
        String featname = fi.getName();
        String id = "-";
        String symbol = "-";
        String gmap = "-";
        FastVector notes = fi.notes;
        if (notes != null) {
            notes = (FastVector)notes.clone();
            for (i = 0; i < notes.size(); ++i) {
                DocItem note = (DocItem)notes.elementAt(i);
                String nm = note.getName();
                boolean got = false;
                if ("ID".equals(nm)) {
                    id = note.getValue();
                    got = true;
                } else if ("name".equals(nm)) {
                    symbol = note.getValue();
                    got = true;
                } else if ("map".equals(nm)) {
                    gmap = note.getValue();
                    got = true;
                }
                if (!got) continue;
                notes.removeElementAt(i);
            }
        }
        this.pr.print(featname);
        this.pr.print("\t");
        this.pr.print(symbol);
        this.pr.print("\t");
        this.pr.print(gmap);
        this.pr.print("\t");
        this.pr.print(fi.getLocation());
        this.pr.print("\t");
        this.pr.print(id);
        this.pr.print("\t");
        if (notes != null) {
            int k = 0;
            for (i = 0; i < notes.size(); ++i) {
                DocItem note = (DocItem)notes.elementAt(i);
                String nm = note.getName();
                if (!"db_xref".equals(nm)) continue;
                if (k > 0) {
                    this.pr.print(",");
                }
                this.pr.print(note.getValue());
                ++k;
                notes.removeElementAt(i);
            }
        }
        this.pr.print("\t");
        if (notes != null) {
            this.keyvalat = 0;
            this.keyvalsep = attribOutSeparator;
            this.writeDocVector(notes, false);
            this.keyvalsep = null;
        }
        this.pr.println();
        ++this.linesout;
    }

    protected void writeFeatureVers2(FeatureItem fi) {
        String featname = fi.getName();
        FastVector notes = fi.notes;
        this.pr.print(featname);
        this.pr.print("\t");
        this.pr.print(fi.getLocation());
        this.pr.print("\t");
        if (notes != null) {
            this.keyvalat = 0;
            this.keyvalsep = attribOutSeparator;
            this.writeDocVector(notes, false);
            this.keyvalsep = null;
        }
        this.pr.println();
        ++this.linesout;
    }

    protected void writeDocItem(DocItem nv, boolean writeAll) {
        int kind;
        this.lastkind = kind = nv.getKind();
        switch (kind) {
            case 30: {
                this.accItem = nv;
                break;
            }
            case 10: {
                this.idItem = nv;
                break;
            }
            case 70: {
                super.writeDocItem(nv, writeAll);
                break;
            }
            case 72: {
                super.writeDocItem(nv, writeAll);
                break;
            }
            case 71: {
                if (!(nv instanceof FeatureItem) || !this.wantFeature(nv)) break;
                FeatureItem fi = (FeatureItem)nv;
                if ("source".equals(fi.getName())) {
                    if (fi.getNote("/AC") != null) {
                        this.accItem = null;
                    }
                    if (this.accItem != null) {
                        fi.putNote(new FeatureNote(this.accItem));
                    }
                    this.accItem = null;
                    if (fi.getNote("/ID") != null) {
                        this.idItem = null;
                    }
                    if (this.idItem != null) {
                        fi.putNote(new FeatureNote(this.idItem));
                    }
                    this.idItem = null;
                }
                if (kWriteVersion == 1) {
                    this.writeFeatureVers1(fi);
                    break;
                }
                this.writeFeatureVers2(fi);
                break;
            }
        }
    }

    protected String getFieldValue(DocItem di) {
        switch (di.getKind()) {
            case 70: {
                return "";
            }
            case 10: {
                String val = di.getValue();
                return val;
            }
            case 30: {
                String val = di.getValue();
                return val;
            }
            case 62: {
                String val = di.getValue();
                return val;
            }
        }
        return super.getFieldValue(di);
    }

    protected String getFieldLabel(int level, DocItem di) {
        String name = null;
        this.indent = 0;
        this.subindent = 0;
        switch (level) {
            default: {
                name = this.fFromForeignFormat ? this.getFieldName(di.getKind()) : di.getName();
                if (name == null || name.length() == 0) {
                    return null;
                }
                return "#" + name + " ";
            }
            case 4: {
                return di.getName() + " ";
            }
            case 5: {
                name = di.getName();
                if (di.hasValue()) {
                    name = name + "=";
                }
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                return name;
            }
            case 6: 
        }
        return "";
    }

    public String getBiodockey(String field) {
        return (String)elabel2keys.get(field);
    }

    public String getFieldName(int kind) {
        String lab = null;
        String biodockey = FlatFeatDoc.getBiodockey(kind);
        if (biodockey != null) {
            lab = (String)keys2elabel.get(biodockey);
        }
        return lab;
    }

    static {
        String pname = System.getProperty(gnomapprop, gnomapprop);
        FlatFeatDoc.getDocProperties(pname, keys2elabel, elabel2keys);
    }
}

