/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.FastHashtable;
import flybase.FastProperties;
import flybase.FastVector;
import flybase.Utils;
import iubio.bioseq.SeqRange;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.DocItem;
import iubio.readseq.FeatureItem;
import java.util.Enumeration;

class GFFDoc
extends BioseqDocImpl {
    public static String gffprop = "GFFDoc";
    public static String attribInSeparator = "; ";
    public static String attribOutSeparator = " ; ";
    private static FastHashtable elabel2keys = new FastHashtable();
    private static FastProperties keys2elabel = new FastProperties();
    String sversion;
    float version;
    String lastgroup;
    FastVector vattr = new FastVector();
    protected String keyvalsep;
    protected int keyvalat;
    protected DocItem accItem;
    protected DocItem idItem;
    int lastkind;
    int partid;
    boolean didtop;
    String lastId;

    public GFFDoc() {
    }

    public GFFDoc(BioseqDoc source) {
        super(source);
        this.fFromForeignFormat = !(source instanceof GFFDoc);
    }

    public GFFDoc(String idname) {
        this.addBasicName(idname);
    }

    public void setSourceDoc(BioseqDoc source) {
        super.setSourceDoc(source);
        this.fFromForeignFormat = !(source instanceof GFFDoc);
    }

    boolean goodval(String v) {
        return v != null && (v.length() > 1 || v.length() == 1 && !"-".equals(v) && !".".equals(v) && !" ".equals(v));
    }

    public void addDocLine(String line) {
        if ((line = line.trim()).length() >= 1) {
            if (line.startsWith("#")) {
                if (line.startsWith("#gff-version")) {
                    this.sversion = line = line.substring("#gff-version".length()).trim();
                    try {
                        this.version = new Float(this.sversion).floatValue();
                    }
                    catch (Exception e) {
                        this.version = 0.0f;
                    }
                }
            } else {
                boolean append = false;
                int level = 4;
                this.inFeatures = 2;
                String[] flds = Utils.splitString(line, "\t");
                if (flds.length < 7) {
                    Debug.println("GFFDoc: read malformed line:" + line);
                    return;
                }
                String feature = flds[2];
                String location = flds[3] + ".." + flds[4];
                if ("-".equals(flds[6])) {
                    location = "complement(" + location + ")";
                }
                String group = "";
                this.vattr.removeAllElements();
                if (flds.length > 8) {
                    String newgrp = null;
                    String attribs = flds[8];
                    int at0 = 0;
                    while (at0 >= 0) {
                        String attr;
                        int at = attribs.indexOf(attribInSeparator, at0);
                        if (at >= at0) {
                            attr = attribs.substring(at0, at);
                            at0 = at + attribInSeparator.length();
                        } else {
                            attr = attribs.substring(at0);
                            at0 = -1;
                            if (attr.endsWith(";")) {
                                attr = attr.substring(0, attr.length() - 1);
                            }
                        }
                        if ((attr = attr.trim()).length() == 0) continue;
                        if (attr.startsWith("group")) {
                            newgrp = attr;
                            continue;
                        }
                        this.vattr.addElement(attr);
                        if (newgrp != null || attr.indexOf("group") <= 0) continue;
                        newgrp = attr;
                    }
                    if (newgrp != null) {
                        group = newgrp;
                    }
                }
                if (group.length() > 0 && group.equals(this.lastgroup)) {
                    try {
                        SeqRange newsr = SeqRange.parse(location);
                        SeqRange sr = this.curFieldItem.getLocation();
                        sr.add(newsr);
                    }
                    catch (Exception sre) {
                        if (Debug.isOn) {
                            sre.printStackTrace();
                        }
                    }
                } else {
                    String oval;
                    this.addFeature(feature, location, 4, false);
                    Enumeration en = this.vattr.elements();
                    while (en.hasMoreElements()) {
                        String attr = (String)en.nextElement();
                        if (!this.goodval(attr)) continue;
                        int spc = attr.indexOf(32);
                        if (spc > 0) {
                            attr = attr.substring(0, spc) + "=" + attr.substring(spc + 1);
                        }
                        if (!attr.startsWith("/")) {
                            attr = "/" + attr;
                        }
                        this.addFeature(feature, attr, 5, true);
                    }
                    if ("source".equals(feature) && this.goodval(flds[0]) && ((oval = this.curFieldItem.getNoteValue("/ID")) == null || !oval.equals(flds[0]))) {
                        this.addFeature(feature, "/ID=" + flds[0], 5, true);
                    }
                    if (this.goodval(flds[1])) {
                        this.addFeature(feature, "/source=" + flds[1], 5, true);
                    }
                    if (this.goodval(flds[5])) {
                        this.addFeature(feature, "/score=" + flds[5], 5, true);
                    }
                }
                this.lastgroup = group;
                this.lastfld = feature;
                this.lastlev = 4;
            }
        }
    }

    public void addDocField(String field, String val, int level, boolean append) {
        int kind = 0;
        if (level == 1 || level == 2 || level == 3) {
            kind = this.getBiodocKind(field);
            switch (kind) {
                case 110: {
                    return;
                }
                case 80: 
                case 90: {
                    level = 1;
                    append = false;
                    break;
                }
            }
        }
        super.addDocField(field, val, kind, level, append);
    }

    protected boolean writeKeyValue(DocItem di) {
        if (this.lastkind == 70) {
            return true;
        }
        String lab = this.getFieldLabel(di);
        String val = this.getFieldValue(di);
        if (lab != null) {
            if (this.keyvalat > 0 && this.keyvalsep != null) {
                this.pr.print(this.keyvalsep);
            }
            ++this.keyvalat;
            this.pr.print(lab);
            val = val.replace('\n', ' ');
            this.pr.print(val);
            return true;
        }
        return false;
    }

    protected void writeDocItem(DocItem nv, boolean writeAll) {
        int kind;
        if (this.linesout == 0) {
            this.partid = 0;
        }
        this.lastkind = kind = nv.getKind();
        switch (kind) {
            case 30: {
                this.accItem = nv;
                break;
            }
            case 10: {
                this.idItem = nv;
                break;
            }
            case 70: {
                super.writeDocItem(nv, writeAll);
                break;
            }
            case 72: {
                super.writeDocItem(nv, writeAll);
                break;
            }
            case 71: {
                DocItem di;
                if (!(nv instanceof FeatureItem) || !this.wantFeature(nv)) break;
                FeatureItem fi = (FeatureItem)nv;
                SeqRange sr = fi.getLocation();
                String strand = ".";
                String name = fi.getName();
                String id = null;
                if ("source".equals(name) && (di = this.findDocItem(fi.notes, "ID", 0)) != null) {
                    id = this.getTrimFieldValue(di);
                }
                if (id == null) {
                    id = this.lastId != null ? this.lastId : (this.idItem != null ? this.getTrimFieldValue(this.idItem) : this.getID());
                }
                this.lastId = id;
                int origin = sr.origin();
                boolean hasparts = sr.next() != null;
                int part = 1;
                while (sr != null) {
                    boolean donotes;
                    strand = sr.isComplement() ? "-" : "+";
                    this.pr.print(id);
                    this.pr.print("\t-\t");
                    this.pr.print(name);
                    this.pr.print("\t");
                    this.pr.print(sr.start() + origin);
                    this.pr.print("\t");
                    this.pr.print(sr.stop() + origin);
                    this.pr.print("\t.\t");
                    this.pr.print(strand);
                    this.pr.print("\t.");
                    this.keyvalat = 0;
                    boolean bl = donotes = part == 1 && fi.notes != null;
                    if (hasparts || donotes) {
                        this.pr.print("\t");
                    }
                    if (hasparts) {
                        if (part == 1) {
                            ++this.partid;
                        }
                        this.pr.print("group " + name + "_" + this.partid);
                        ++this.keyvalat;
                    }
                    if (donotes) {
                        this.keyvalsep = attribOutSeparator;
                        this.writeDocVector(fi.notes, false);
                        this.keyvalsep = null;
                    }
                    this.pr.println();
                    ++this.linesout;
                    ++part;
                    sr = sr.next();
                }
                break;
            }
        }
    }

    protected String getFieldValue(DocItem di) {
        switch (di.getKind()) {
            case 70: {
                return "";
            }
            case 10: {
                String val = di.getValue();
                return val;
            }
            case 30: {
                String val = di.getValue();
                return val;
            }
            case 62: {
                String val = di.getValue();
                return val;
            }
        }
        return super.getFieldValue(di);
    }

    protected String getFieldLabel(int level, DocItem di) {
        String name = null;
        this.indent = 0;
        this.subindent = 0;
        switch (level) {
            default: {
                name = this.fFromForeignFormat ? this.getFieldName(di.getKind()) : di.getName();
                if (name == null || name.length() == 0) {
                    return null;
                }
                return "#" + name + " ";
            }
            case 4: {
                return di.getName() + " ";
            }
            case 5: {
                name = di.getName();
                if (di.hasValue()) {
                    name = name + " ";
                }
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                return name;
            }
            case 6: 
        }
        return "";
    }

    public String getBiodockey(String field) {
        return (String)elabel2keys.get(field);
    }

    public String getFieldName(int kind) {
        String lab = null;
        String biodockey = GFFDoc.getBiodockey(kind);
        if (biodockey != null) {
            lab = (String)keys2elabel.get(biodockey);
        }
        return lab;
    }

    static {
        String pname = System.getProperty(gffprop, gffprop);
        GFFDoc.getDocProperties(pname, keys2elabel, elabel2keys);
    }
}

