/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Debug;
import flybase.FastProperties;
import iubio.bioseq.BaseKind;
import iubio.readseq.OutBiobase;
import iubio.readseq.OutBiobaseIntf;
import java.io.InputStream;

public class ToAminoBase
extends OutBiobase {
    public static String codontable = "codon";
    static FastProperties codons = null;
    int i = 0;
    char[] acodon = new char[]{'X', 'X', 'X'};

    public ToAminoBase(OutBiobaseIntf nextout) {
        super(nextout);
        if (codons == null) {
            this.readCodons();
        }
    }

    public int outSeqChar(int c) {
        if (this.outtest != null) {
            c = this.outtest.outSeqChar(c);
        }
        if (c < 0) {
            this.i = 0;
            return 0;
        }
        int b = this.i % 3;
        ++this.i;
        this.acodon[b] = Character.toUpperCase((char)c);
        if (b != 2) {
            return 0;
        }
        String aminos = codons.getProperty(new String(this.acodon));
        if (aminos == null) {
            return 120;
        }
        return BaseKind.Amino321(aminos);
    }

    void readCodons() {
        if (codons == null) {
            try {
                codons = new FastProperties();
                String pname = System.getProperty(codontable, codontable);
                pname = AppResources.global.findPath(pname + ".properties");
                Debug.println("codontable: " + pname);
                InputStream ins = AppResources.global.getStream(pname);
                if (ins != null) {
                    codons.load(ins);
                    ins.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

